package cn.wise.sc.acquisition.business.controller;


import cn.wise.sc.acquisition.business.model.query.TAnnouncementQuery;
import cn.wise.sc.acquisition.business.service.ITAnnouncementService;
import cn.wise.sc.acquisition.business.wrapper.page.Query;
import com.baomidou.mybatisplus.extension.api.R;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;

import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

/**
 * <p>
 *  前端控制器
 * </p>
 *
 * @author renchao
 * @since 2021-05-06
 */
@RestController
@RequestMapping("/business/t-announcement")
@Api(tags = "广告通知接口")
public class TAnnouncementController {

    @Autowired
    private ITAnnouncementService itAnnouncementService;

    /**
     * 根据条件查询广告通知 分页
     *
     * @return
     */
    @ApiOperation(value = "根据条件查询广告通知")
    @RequestMapping(value = "/getPage", method = RequestMethod.GET)
    public R getPage(Query query ) {
        TAnnouncementQuery param = new TAnnouncementQuery();
        return itAnnouncementService.getPage(param, query);
    }


    /**
     * 根据uid获取广告
     *
     * @return
     */
    @ApiOperation(value = "根据uid获取广告")
    @ApiImplicitParams(value = {
            @ApiImplicitParam(name = "uid", value = "uid", paramType = "query", dataType = "String")
    })
    @RequestMapping(value = "/getByUid", method = RequestMethod.GET)
    public R getByUid(String uid) {
        TAnnouncementQuery param = new TAnnouncementQuery();
        param.setUid(uid);
        return itAnnouncementService.getByUid(param);
    }

}

