package cn.wise.sc.acquisition.business.controller;


import cn.wise.im.common.http.R;
import cn.wise.sc.acquisition.business.model.PageQuery;
import cn.wise.sc.acquisition.business.model.query.TEquipmentAccountQuery;
import cn.wise.sc.acquisition.business.service.ITEquipmentAccountService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 *  前端控制器
 * </p>
 *
 * @author ztw
 * @since 2021-04-23
 */
@Api(tags = "设备管理")
@RestController
@RequestMapping("/business/t-equipment-account")
@Validated
public class TEquipmentAccountController {

	@Autowired
	private ITEquipmentAccountService equipmentAccountService;


	@ApiOperation(value = "设备分页列表")
	@ApiImplicitParams(value = {
			@ApiImplicitParam(name = "EquipmentName", value = "设备名称", paramType = "query", dataType = "EquipmentName")
	})
	@GetMapping("/getPage")
	public R getPage(PageQuery pageQuery, String EquipmentName) {
		return equipmentAccountService.getPage(pageQuery, EquipmentName);
	}

	@ApiOperation(value = "新增设备")
	@PostMapping("/create")
	public R create(@RequestBody  TEquipmentAccountQuery query) {
		return equipmentAccountService.create(query);
	}





}

