package cn.wise.sc.acquisition.business.controller;


import cn.wise.im.common.http.R;
import cn.wise.sc.acquisition.business.model.PageQuery;
import cn.wise.sc.acquisition.business.model.query.TEquipmentAccountQuery;
import cn.wise.sc.acquisition.business.model.query.TEquipmentCheckQuery;
import cn.wise.sc.acquisition.business.service.ITEquipmentCheckService;
import io.swagger.annotations.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.NotBlank;

/**
 * <p>
 *  前端控制器
 * </p>
 *
 * @author ztw
 * @since 2021-04-25
 */
@Api(tags = "设备点检管理")
@RestController
@RequestMapping("/business/t-equipment-check")
@Validated
public class TEquipmentCheckController {

	@Autowired
	private ITEquipmentCheckService equipmentCheckService;

	@ApiOperation(value = "设备点检分页")
	@ApiImplicitParams(value = {
			@ApiImplicitParam(name = "EquipmentName", value = "设备名称", paramType = "query", dataType = "EquipmentName")
	})
	@GetMapping("/getPage")
	public R getPage(PageQuery pageQuery, String EquipmentName) {
		return equipmentCheckService.getPage(pageQuery, EquipmentName);
	}

	@ApiOperation(value = "设备点检详情")
	@GetMapping("/getDetail/{EquipmentID}")
	public R getDetail(@PathVariable @NotBlank String EquipmentID) {
		return equipmentCheckService.getDetail(EquipmentID);
	}

	@ApiOperation(value = "保存设备点检结果")
	@PostMapping("/checking")
	public R update(@RequestBody TEquipmentCheckQuery query) {
		return equipmentCheckService.checking(query);
	}


}

