package cn.wise.sc.acquisition.business.controller;


import cn.wise.im.common.http.R;
import cn.wise.sc.acquisition.business.model.PageQuery;
import cn.wise.sc.acquisition.business.model.query.TEquipmentTroubleQuery;
import cn.wise.sc.acquisition.business.service.ITEquipmentTroubleService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.NotBlank;

/**
 * <p>
 *  前端控制器
 * </p>
 *
 * @author ztw
 * @since 2021-04-25
 */
@Api(tags = "设备隐患管理")
@RestController
@RequestMapping("/business/t-equipment-trouble")
@Validated
public class TEquipmentTroubleController {

	@Autowired
	private ITEquipmentTroubleService equipmentTroubleService;


	@ApiOperation(value = "设备隐患分页")
	@ApiImplicitParams(value = {
			@ApiImplicitParam(name = "EquipmentName", value = "设备名称", paramType = "query", dataType = "EquipmentName")
	})
	@GetMapping("/getPage")
	public R getPage(PageQuery pageQuery, String EquipmentName) {
		return equipmentTroubleService.getPage(pageQuery, EquipmentName);
	}

	@ApiOperation(value = "设备隐患详情")
	@GetMapping("/getDetail/{EquipmentID}")
	public R getDetail(@PathVariable @NotBlank String EquipmentID) {
		return equipmentTroubleService.getDetail(EquipmentID);
	}

	@ApiOperation(value = "保存设备隐患结果")
	@PostMapping("/trouble")
	public R trouble(@RequestBody TEquipmentTroubleQuery query) {
		return equipmentTroubleService.trouble(query);
	}
	

}

