package cn.wise.sc.acquisition.business.controller;


import cn.wise.im.common.http.R;
import cn.wise.sc.acquisition.business.model.PageQuery;
import cn.wise.sc.acquisition.business.model.query.TEquipmentAccountQuery;
import cn.wise.sc.acquisition.business.model.query.TMaterialOutQuery;
import cn.wise.sc.acquisition.business.service.ITEquipmentAccountService;
import cn.wise.sc.acquisition.business.service.ITMaterialOutService;
import cn.wise.sc.acquisition.business.util.DateUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 * 前端控制器
 * </p>
 *
 * @author renchao
 * @since 2021-04-27
 */
@Api(tags = "存货出库")
@RestController
@RequestMapping("/business/t-material-out")
@Validated
public class TMaterialOutController {

    @Autowired
    private ITMaterialOutService materialOutService;


    @ApiOperation(value = "出库分页列表")
    @GetMapping("/getPage")
    public R getPage(PageQuery pageQuery) {
        return materialOutService.getPage(pageQuery);
    }

    @ApiOperation(value = "领用出库")
    @PostMapping("/delivery")
    public R delivery(@RequestBody TMaterialOutQuery query) {
        return materialOutService.delivery(query);
    }


    @ApiOperation(value = "修改领用出库")
    @PostMapping("/update")
    public R update(@RequestBody TMaterialOutQuery query) {
        return materialOutService.update(query);
    }


    @ApiOperation(value = "领用出库详情")
    @GetMapping("/getDetail/{Uid}")
    public R getDetail(@PathVariable String Uid) {
        return materialOutService.getDetail(Uid);
    }


    @ApiOperation(value = "根据条件查询物资消耗 可分页模糊查询")
    @ApiImplicitParams(value = {
            @ApiImplicitParam(name = "processesName", value = "工序名称", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = "consumeDate", value = "消耗日期", paramType = "query", dataType = "String")
    })
    @GetMapping("/getConsumePage")
    public R getConsumePage(PageQuery pageQuery, String processesName, String consumeDate) {
        TMaterialOutQuery tMaterialOutQuery = new TMaterialOutQuery();
        tMaterialOutQuery.setProcessesName(processesName);
        if (StringUtils.isNotBlank(consumeDate)) {
            tMaterialOutQuery.setConsumeDate(DateUtil.strToTime(consumeDate));
        }
        return materialOutService.getConsumePage(tMaterialOutQuery, pageQuery);
    }

    /**
     * 获取工序字典
     * @return
     */
    @ApiOperation(value = "获取工序字典")
    @GetMapping("/getProcessesType")
    public R getProcessesType() {
        return materialOutService.getProcessesType( );
    }


}

