package cn.wise.sc.acquisition.business.controller;


import cn.wise.sc.acquisition.business.service.ITMineStopeService;
import cn.wise.sc.acquisition.business.wrapper.page.Query;
import com.baomidou.mybatisplus.extension.api.R;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;

import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

/**
 * <p>
 *  前端控制器
 * </p>
 *
 * @author renchao
 * @since 2021-04-30
 */
@RestController
@Api(tags = "生产工序-矿山爆区表")
@RequestMapping("/business/t-mine-stope")
public class TMineStopeController {

    @Autowired
    private ITMineStopeService itMineStopeService;

    /**
     * 根据条件查询爆破工序 分页
     *
     * @return
     */
    @ApiOperation(value = "根据条件矿山爆区表 可分页模糊查询")
    @RequestMapping(value = "/getPage", method = RequestMethod.GET)
    public R getPage(Query query) {
        return itMineStopeService.getPage(null, query);
    }

}

