package cn.wise.sc.acquisition.business.controller;


import cn.wise.sc.acquisition.business.model.query.TMineWorkemployeesQuery;
import cn.wise.sc.acquisition.business.service.ITMineWorkemployeesService;
import cn.wise.sc.acquisition.business.util.DateUtil;
import cn.wise.sc.acquisition.business.wrapper.page.Query;
import com.baomidou.mybatisplus.extension.api.R;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

/**
 * <p>
 *  前端控制器 员工上班统计
 * </p>
 *
 * @author renchao
 * @since 2021-05-17
 */
@RestController
@RequestMapping("/business/t-mine-workemployees")
public class TMineWorkemployeesController {

    @Autowired
    private ITMineWorkemployeesService itMineWorkemployeesService;


    /**
     * 根据条件查询员工上班统计 分页
     *
     * @return
     */
    @ApiOperation(value = "根据条件查询员工上班统计 分页")
    @ApiImplicitParams(value = {
            @ApiImplicitParam(name = "gzsj", value = "搜索关键字,上班日期", paramType = "query", dataType = "String")
    })
    @RequestMapping(value = "/getPage", method = RequestMethod.GET)
    public R getPage(Query query, String gzsj) {
        TMineWorkemployeesQuery param = new TMineWorkemployeesQuery();
        if (StringUtils.isNotBlank(gzsj)) {
            param.setGzsj(DateUtil.strToTime(gzsj));
        }
        return itMineWorkemployeesService.getPage(param, query);
    }

    /**
     * 增加员工上班统计
     *
     * @param tMineWorkemployeesQuery
     * @return
     */
    @ApiOperation(value = "增加员工上班统计")
    @RequestMapping(value = "/insertTMineWorkemployees", method = RequestMethod.POST)
    public R insertTMineWorkemployees(@RequestBody TMineWorkemployeesQuery tMineWorkemployeesQuery) {
        return itMineWorkemployeesService.insertTMineWorkemployees(tMineWorkemployeesQuery);
    }


    /**
     * 根据uid员工上班统计
     *
     * @param tMineWorkemployeesQuery
     * @return
     */
    @ApiOperation(value = "根据uid员工上班统计")
    @RequestMapping(value = "/updateByUid", method = RequestMethod.POST)
    public R updateByUid(@RequestBody TMineWorkemployeesQuery tMineWorkemployeesQuery) {
        return itMineWorkemployeesService.updateByUid(tMineWorkemployeesQuery);
    }

}

