package cn.wise.sc.acquisition.business.controller;


import cn.wise.sc.acquisition.business.model.query.TProcessesAuxiliaryQuery;
import cn.wise.sc.acquisition.business.service.ITProcessesAuxiliaryService;
import cn.wise.sc.acquisition.business.util.DateUtil;
import cn.wise.sc.acquisition.business.wrapper.page.Query;
import com.baomidou.mybatisplus.extension.api.R;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

/**
 * <p>
 *  前端控制器
 * </p>
 *
 * @author renchao
 * @since 2021-04-30
 */
@RestController
@Api(tags = "生成工序-辅助工序")
@RequestMapping("/business/t-processes-auxiliary")
public class TProcessesAuxiliaryController {

    @Autowired
    private ITProcessesAuxiliaryService itProcessesAuxiliaryService;

    /**
     * 根据条件查询辅助工序 分页
     *
     * @return
     */
    @ApiOperation(value = "根据条件查询辅助工序 可分页模糊查询")
    @ApiImplicitParams(value = {
            @ApiImplicitParam(name = "EquipmentID", value = "搜索关键字 设备编号", paramType = "query", dataType = "String")
    })
    @RequestMapping(value = "/getPage", method = RequestMethod.GET)
    public R getPage(Query query, String EquipmentID) {
        TProcessesAuxiliaryQuery param = new TProcessesAuxiliaryQuery();
        param.setEquipmentID(EquipmentID);
        return itProcessesAuxiliaryService.getPage(param, query);
    }


    /**
     * 根据uid修改辅助工序
     *
     * @param tProcessesAuxiliaryQuery
     * @return
     */
    @ApiOperation(value = "根据uid修改辅助工序")
    @RequestMapping(value = "/updateByUid", method = RequestMethod.POST)
    public R updateByUid(@RequestBody TProcessesAuxiliaryQuery tProcessesAuxiliaryQuery) {
        return itProcessesAuxiliaryService.updateByUid(tProcessesAuxiliaryQuery);
    }


    /**
     * 增加辅助工序
     *
     * @param tProcessesAuxiliaryQuery
     * @return
     */
    @ApiOperation(value = "增加辅助工序")
    @RequestMapping(value = "/insertTProcessesAuxiliary", method = RequestMethod.POST)
    public R insertTProcessesAuxiliary(@RequestBody TProcessesAuxiliaryQuery tProcessesAuxiliaryQuery) {
        return itProcessesAuxiliaryService.insertTProcessesAuxiliary(tProcessesAuxiliaryQuery);
    }
}

