package cn.wise.sc.acquisition.business.controller;


import cn.wise.sc.acquisition.business.model.query.TProcessesBlastQuery;
import cn.wise.sc.acquisition.business.service.ITProcessesBlastService;
import cn.wise.sc.acquisition.business.util.DateUtil;
import cn.wise.sc.acquisition.business.wrapper.page.Query;
import com.baomidou.mybatisplus.extension.api.R;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.NotBlank;

/**
 * <p>
 * 前端控制器
 * </p>
 *
 * @author renchao
 * @since 2021-04-29
 */
@RestController
@Api(tags = "生成工序-爆破工序")
@RequestMapping("/business/t-processes-blast")
public class TProcessesBlastController {

    @Autowired
    ITProcessesBlastService itProcessesBlastService;

    /**
     * 根据条件查询爆破工序 分页
     *
     * @return
     */
    @ApiOperation(value = "根据条件查询爆破工序 可分页模糊查询")
    @ApiImplicitParams(value = {
            @ApiImplicitParam(name = "blastDate", value = "搜索关键字,爆破时间", paramType = "query", dataType = "String")
    })
    @RequestMapping(value = "/getPage", method = RequestMethod.GET)
    public R getPage(Query query, String blastDate) {
        TProcessesBlastQuery param = new TProcessesBlastQuery();
        if (StringUtils.isNotBlank(blastDate)) {
            param.setBlastDate(DateUtil.strToTime(blastDate));
        }
        return itProcessesBlastService.getPage(param, query);
    }

    /**
     * 根据uid修改爆破工序
     *
     * @param tProcessesBlastQuery
     * @return
     */
    @ApiOperation(value = "根据uid修改爆破工序")
    @RequestMapping(value = "/updateByUid", method = RequestMethod.POST)
    public R updateByUid(@RequestBody TProcessesBlastQuery tProcessesBlastQuery) {
        return itProcessesBlastService.updateByUid(tProcessesBlastQuery);
    }


    /**
     * 根据uid查询爆破工序
     *
     * @param uid
     * @return
     */
    @ApiOperation(value = "根据uid查询爆破工序")
    @GetMapping(value = "/getByUid/{uid}")
    public R getByUid(@PathVariable @NotBlank String uid) {
        TProcessesBlastQuery param = new TProcessesBlastQuery();
        param.setUid(uid);
        return itProcessesBlastService.getByUid(param);
    }

}

