package cn.wise.sc.acquisition.business.controller;


import cn.wise.sc.acquisition.business.model.query.TProcessesBlastdesignHoleQuery;
import cn.wise.sc.acquisition.business.service.ITProcessesBlastdesignHoleService;
import cn.wise.sc.acquisition.business.util.DateUtil;
import cn.wise.sc.acquisition.business.wrapper.page.Query;
import com.baomidou.mybatisplus.extension.api.R;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.NotBlank;


/**
 * <p>
 * 前端控制器
 * </p>
 *
 * @author renchao
 * @since 2021-04-27
 */
@RestController
@RequestMapping("/business/t-processes-blastdesign-hole")
@Api(tags = "生成工序-炮孔设计")
public class TProcessesBlastdesignHoleController {

    @Autowired
    private ITProcessesBlastdesignHoleService itProcessesBlastdesignHoleService;

    /**
     * 根据条件查询炮孔设计 分页
     *
     * @return
     */
    @ApiOperation(value = "根据条件查询炮孔设计 可分页")
    @ApiImplicitParams(value = {
            @ApiImplicitParam(name = "designDate", value = "设计时间", paramType = "query", dataType = "String")
    })
    @RequestMapping(value = "/getPage", method = RequestMethod.GET)
    public R getPage(String designDate, Query query) {
        TProcessesBlastdesignHoleQuery param = new TProcessesBlastdesignHoleQuery();
        if (StringUtils.isNotBlank(designDate)) {
            param.setDesignDate(DateUtil.strToTime(designDate));
        }
        return itProcessesBlastdesignHoleService.getPage(param, query);
    }


    /**
     * 根据uid修改炮孔设计
     *
     * @param tProcessesBlastdesignHoleQuery
     * @return
     */
    @ApiOperation(value = "根据uid修改炮孔设计")
    @RequestMapping(value = "/updateByUid", method = RequestMethod.POST)
    public R updateByUid(@RequestBody TProcessesBlastdesignHoleQuery tProcessesBlastdesignHoleQuery) {
        return itProcessesBlastdesignHoleService.updateByUid(tProcessesBlastdesignHoleQuery);
    }


//    /**
//     * 根据uid删除炮孔设计
//     *
//     * @param tProcessesBlastdesignHoleQuery
//     * @return
//     */
//    @ApiOperation(value = "根据uid删除炮孔设计")
//    @RequestMapping(value = "/deleteByUid", method = RequestMethod.POST)
//    public R deleteByUid(@RequestBody TProcessesBlastdesignHoleQuery tProcessesBlastdesignHoleQuery) {
//        return itProcessesBlastdesignHoleService.deleteByUid(tProcessesBlastdesignHoleQuery);
//    }


    /**
     * 根据uid增加炮孔设计
     *
     * @param tProcessesBlastdesignHoleQuery
     * @return
     */
    @ApiOperation(value = "根据uid增加炮孔设计")
    @RequestMapping(value = "/insertTProcessesBlastdesignHole", method = RequestMethod.POST)
    public R insertTProcessesBlastdesignHole(@RequestBody TProcessesBlastdesignHoleQuery tProcessesBlastdesignHoleQuery) {
        return itProcessesBlastdesignHoleService.insertTProcessesBlastdesignHole(tProcessesBlastdesignHoleQuery);
    }


    /**
     * 根据uid查询炮孔设计
     *
     * @return
     */
    @ApiOperation(value = "根据uid查询炮孔设计")
    @GetMapping(value = "/getByUid/{uid}")
    public R getByUid(@PathVariable @NotBlank String uid) {
        TProcessesBlastdesignHoleQuery param = new TProcessesBlastdesignHoleQuery();
        param.setUid(uid);
        return itProcessesBlastdesignHoleService.getByUid(param);
    }
}

