package cn.wise.sc.acquisition.business.controller;


import cn.wise.sc.acquisition.business.model.query.TProcessesBlastdesignHoleQuery;
import cn.wise.sc.acquisition.business.model.query.TProcessesBlastdesignVolumeQuery;
import cn.wise.sc.acquisition.business.service.ITProcessesBlastdesignVolumeService;
import cn.wise.sc.acquisition.business.wrapper.page.Query;
import com.baomidou.mybatisplus.extension.api.R;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

/**
 * <p>
 * 前端控制器
 * </p>
 *
 * @author renchao
 * @since 2021-04-27
 */
@RestController
@RequestMapping("/business/t-processes-blastdesign-volume")
@Api(tags = "生成工序-设计爆区爆破量（基本信息）")
public class TProcessesBlastdesignVolumeController {

    @Autowired
    private ITProcessesBlastdesignVolumeService itProcessesBlastdesignVolumeService;

    /**
     * 查询设计爆区爆破量列表 分页
     *
     * @return
     */
    @ApiOperation(value = "查询设计爆区爆破量列表 分页")
    @RequestMapping(value = "/getPage", method = RequestMethod.GET)
    public R getPage(Query query) {
        //tProcessesBlastdesignVolumeQuery 暂时传空，方便以后加需求
        return itProcessesBlastdesignVolumeService.getPage(null, query);
    }

    /**
     * 根据条件修改设计爆区爆破量
     *
     * @param tProcessesBlastdesignVolumeQuery
     * @return
     */
    @ApiOperation(value = "根据条件修改设计爆区爆破量")
    @RequestMapping(value = "/updateByQuery", method = RequestMethod.POST)
    public R updateByQuery(@RequestBody TProcessesBlastdesignVolumeQuery tProcessesBlastdesignVolumeQuery) {
        return itProcessesBlastdesignVolumeService.updateByQuery(tProcessesBlastdesignVolumeQuery);
    }


    /**
     * 根据条件查询设计爆区爆破量
     *
     * @return
     */
    @ApiOperation(value = "根据条件查询设计爆区爆破量")
    @ApiImplicitParams(value = {
            @ApiImplicitParam(name = "blastAreaName", value = "爆区名称", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = "stepName", value = "平台名称", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = "stopeName", value = "采区名称", paramType = "query", dataType = "String")
    })
    @RequestMapping(value = "/getByQuery", method = RequestMethod.GET)
    public R getByQuery(String blastAreaName, String stepName, String stopeName) {
        //封装query对象
        TProcessesBlastdesignVolumeQuery param = new TProcessesBlastdesignHoleQuery();
        param.setBlastAreaName(blastAreaName);
        param.setStepName(stepName);
        param.setStopeName(stopeName);
        return itProcessesBlastdesignVolumeService.getByQuery(param);
    }
}

