package cn.wise.sc.acquisition.business.controller;


import cn.wise.sc.acquisition.business.model.query.TProcessesCrusherQuery;
import cn.wise.sc.acquisition.business.service.ITProcessesCrusherService;
import cn.wise.sc.acquisition.business.wrapper.page.Query;
import com.baomidou.mybatisplus.extension.api.R;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.NotBlank;

/**
 * <p>
 * 前端控制器
 * </p>
 *
 * @author renchao
 * @since 2021-04-30
 */
@RestController
@Api(tags = "生成工序-破碎工序")
@RequestMapping("/business/t-processes-crusher")
public class TProcessesCrusherController {

    @Autowired
    private ITProcessesCrusherService itProcessesCrusherService;

    /**
     * 根据条件查询破碎工序 分页
     *
     * @return
     */
    @ApiOperation(value = "根据条件查询破碎工序 可分页模糊查询")
    @ApiImplicitParams(value = {
            @ApiImplicitParam(name = "equipmentID", value = "搜索关键字 设备编号", paramType = "query", dataType = "String")
    })
    @RequestMapping(value = "/getPage", method = RequestMethod.GET)
    public R getPage(Query query, String equipmentID) {
        TProcessesCrusherQuery param = new TProcessesCrusherQuery();
        param.setEquipmentID(equipmentID);
        return itProcessesCrusherService.getPage(param, query);
    }


    /**
     * 根据uid修改破碎工序
     *
     * @param tProcessesCrusherQuery
     * @return
     */
    @ApiOperation(value = "根据uid修改破碎工序")
    @RequestMapping(value = "/updateByUid", method = RequestMethod.POST)
    public R updateByUid(@RequestBody TProcessesCrusherQuery tProcessesCrusherQuery) {
        return itProcessesCrusherService.updateByUid(tProcessesCrusherQuery);
    }

    /**
     * 增加辅助工序
     *
     * @param tProcessesCrusherQuery
     * @return
     */
    @ApiOperation(value = "增加破碎工序")
    @RequestMapping(value = "/insertTProcessesCrusher", method = RequestMethod.POST)
    public R insertTProcessesCrusher(@RequestBody TProcessesCrusherQuery tProcessesCrusherQuery) {
        return itProcessesCrusherService.insertTProcessesCrusher(tProcessesCrusherQuery);
    }


    /**
     * 根据uid获取破碎工序
     *
     * @return
     */
    @ApiOperation(value = "根据uid获取破碎工序")
    @GetMapping(value = "/getByUid/{uid}")
    public R getByUid(@PathVariable @NotBlank String uid) {
        TProcessesCrusherQuery tProcessesCrusherQuery = new TProcessesCrusherQuery();
        tProcessesCrusherQuery.setUid(uid);
        return itProcessesCrusherService.getByUid(tProcessesCrusherQuery);
    }
}

