package cn.wise.sc.acquisition.business.controller;


import cn.wise.im.common.http.R;
import cn.wise.sc.acquisition.business.model.PageQuery;
import cn.wise.sc.acquisition.business.model.query.TEquipmentRunQuery;
import cn.wise.sc.acquisition.business.model.query.TProcessesDiggingQuery;
import cn.wise.sc.acquisition.business.service.ITProcessesDiggingService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.NotBlank;

/**
 * <p>
 *  前端控制器
 * </p>
 *
 * @author ztw
 * @since 2021-04-28
 */
@Api(tags = "生产工序-装车工序")
@RestController
@RequestMapping("/business/t-processes-digging")
@Validated
public class TProcessesDiggingController {

	@Autowired
	private ITProcessesDiggingService processesDiggingService;

	@ApiOperation(value = "装车工序-今日数量统计", notes = "digDate 如果不传默认查询当天数据")
	@GetMapping("/getTodayData")
	public R getTodayData(String digDate) {
		return processesDiggingService.getTodayData(digDate);
	}


	@ApiOperation(value = "装车工序分页")
	@ApiImplicitParams(value = {
			@ApiImplicitParam(name = "digDate", value = "装车时间", paramType = "query", dataType = "String")
	})
	@GetMapping("/getPage")
	public R getPage(PageQuery pageQuery, String digDate) {
		return processesDiggingService.getPage(pageQuery, digDate);
	}


	@ApiOperation(value = "保存装车工序")
	@PostMapping("/save")
	public R save(@RequestBody TProcessesDiggingQuery query) {
		return processesDiggingService.save(query);
	}

	@ApiOperation(value = "修改装车工序")
	@PostMapping("/update")
	public R update(@RequestBody TProcessesDiggingQuery query) {
		return processesDiggingService.update(query);
	}

	@ApiOperation(value = "装车工序详情")
	@GetMapping("/getDetail/{Uid}")
	public R getDetail(@PathVariable @NotBlank String Uid) {
		return processesDiggingService.getDetail(Uid);
	}




}

