package cn.wise.sc.acquisition.business.controller;


import cn.wise.sc.acquisition.business.model.query.TProcessesDrillingQuery;
import cn.wise.sc.acquisition.business.service.ITProcessesDrillingService;
import cn.wise.sc.acquisition.business.util.DateUtil;
import cn.wise.sc.acquisition.business.wrapper.page.Query;
import com.baomidou.mybatisplus.extension.api.R;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.NotBlank;

/**
 * <p>
 * 前端控制器
 * </p>
 *
 * @author renchao
 * @since 2021-04-29
 */
@RestController
@Api(tags = "生成工序-穿孔工序")
@RequestMapping("/business/t-processes-drilling")
public class TProcessesDrillingController {

    @Autowired
    private ITProcessesDrillingService itProcessesDrillingService;

    /**
     * 根据条件查询穿孔工序 分页
     *
     * @return
     */
    @ApiOperation(value = "根据条件查询穿孔工序 可分页模糊查询")
    @ApiImplicitParams(value = {
            @ApiImplicitParam(name = "drillingDate", value = "搜索关键字,设计日期", paramType = "query", dataType = "String")
    })
    @RequestMapping(value = "/getPage", method = RequestMethod.GET)
    public R getPage(Query query, String drillingDate) {
        TProcessesDrillingQuery param = new TProcessesDrillingQuery();
        if (StringUtils.isNotBlank(drillingDate)) {
            param.setDrillingDate(DateUtil.strToTime(drillingDate));
        }
        return itProcessesDrillingService.getPage(param, query);
    }


    /**
     * 根据uid修改穿孔工序
     *
     * @param tProcessesDrillingQuery
     * @return
     */
    @ApiOperation(value = "根据uid修改穿孔工序")
    @RequestMapping(value = "/updateByUid", method = RequestMethod.POST)
    public R updateByUid(@RequestBody TProcessesDrillingQuery tProcessesDrillingQuery) {
        return itProcessesDrillingService.updateByUid(tProcessesDrillingQuery);
    }


    /**
     * 修改所有爆破日期
     *
     * @param tProcessesDrillingQuery
     * @return
     */
    @ApiOperation(value = "修改所有爆破日期")
    @RequestMapping(value = "/updateAllBlastDate", method = RequestMethod.POST)
    public R updateAllBlastDate(@RequestBody TProcessesDrillingQuery tProcessesDrillingQuery) {
        return itProcessesDrillingService.updateAllBlastDate(tProcessesDrillingQuery);
    }


    /**
     * 根据uid获取详细信息
     *
     * @param uid
     * @return
     */
    @ApiOperation(value = "根据uid获取穿孔工序")
    @GetMapping(value = "/getByUid/{uid}")
    public R getByUid(@PathVariable @NotBlank String uid) {
        TProcessesDrillingQuery tProcessesDrillingQuery = new TProcessesDrillingQuery();
        tProcessesDrillingQuery.setUid(uid);
        return itProcessesDrillingService.getByUid(tProcessesDrillingQuery);
    }


}

