package cn.wise.sc.acquisition.business.controller;


import cn.wise.im.common.http.R;
import cn.wise.sc.acquisition.business.model.PageQuery;
import cn.wise.sc.acquisition.business.model.query.TProcessesDiggingQuery;
import cn.wise.sc.acquisition.business.model.query.TProcessesTruckQuery;
import cn.wise.sc.acquisition.business.service.ITProcessesDiggingService;
import cn.wise.sc.acquisition.business.service.ITProcessesTruckService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.NotBlank;

/**
 * <p>
 *  前端控制器
 * </p>
 *
 * @author ztw
 * @since 2021-04-26
 */
@Api(tags = "生产工序-运输工序")
@RestController
@RequestMapping("/business/t-processes-truck")
@Validated
public class TProcessesTruckController {

	@Autowired
	private ITProcessesTruckService processesTruckService;


	@ApiOperation(value = "运输工序-今日数量统计", notes = "deliveryDate 如果不传默认查询当天数据")
	@GetMapping("/getTodayData")
	public R getTodayData(String deliveryDate) {
		return processesTruckService.getTodayData(deliveryDate);
	}


	@ApiOperation(value = "运输工序分页")
	@ApiImplicitParams(value = {
			@ApiImplicitParam(name = "deliveryDate", value = "运输时间", paramType = "query", dataType = "String")
	})
	@GetMapping("/getPage")
	public R getPage(PageQuery pageQuery, String deliveryDate) {
		return processesTruckService.getPage(pageQuery, deliveryDate);
	}


	@ApiOperation(value = "保存运输工序")
	@PostMapping("/save")
	public R save(@RequestBody TProcessesTruckQuery query) {
		return processesTruckService.save(query);
	}

	@ApiOperation(value = "修改运输工序")
	@PostMapping("/update")
	public R update(@RequestBody TProcessesTruckQuery query) {
		return processesTruckService.update(query);
	}

	@ApiOperation(value = "运输工序详情")
	@GetMapping("/getDetail/{Uid}")
	public R getDetail(@PathVariable @NotBlank String Uid) {
		return processesTruckService.getDetail(Uid);
	}





}

