package cn.wise.sc.acquisition.business.controller;


import cn.wise.im.common.http.R;
import cn.wise.sc.acquisition.business.model.PageQuery;
import cn.wise.sc.acquisition.business.model.query.TMaterialOutQuery;
import cn.wise.sc.acquisition.business.model.query.TSafeTroubleQuery;
import cn.wise.sc.acquisition.business.service.ITMaterialOutService;
import cn.wise.sc.acquisition.business.service.ITSafeTroubleService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;

/**
 * <p>
 *  前端控制器
 * </p>
 *
 * @author renchao
 * @since 2021-04-27
 */
@Api(tags = "安全台账")
@RestController
@RequestMapping("/business/t-safe-trouble")
@Validated
public class TSafeTroubleController {


	@Autowired
	private ITSafeTroubleService safeTroubleService;


	@ApiOperation(value = "安全台账分页列表")
	@GetMapping("/getPage")
	public R getPage(PageQuery pageQuery) {
		return safeTroubleService.getPage(pageQuery);
	}

	@ApiOperation(value = "添加隐患")
	@PostMapping("/save")
	public R save(TSafeTroubleQuery query, HttpServletRequest request) {
		return safeTroubleService.save(query, request);
	}

	@ApiOperation(value = "隐患整改")
	@PostMapping("/update")
	public R update(TSafeTroubleQuery query, HttpServletRequest request) {
		return safeTroubleService.update(query, request);
	}

	@ApiOperation(value = "隐患详情")
	@GetMapping("/getDetail/{Uid}")
	public R getDetail(@PathVariable String Uid) {
		return safeTroubleService.getDetail(Uid);
	}




}

