package cn.wise.sc.acquisition.business.controller;


import cn.wise.sc.acquisition.business.model.query.TSampleLaboratorysheetQuery;
import cn.wise.sc.acquisition.business.service.ITSampleLaboratorysheetService;
import com.baomidou.mybatisplus.extension.api.R;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotBlank;

/**
 * <p>
 * 前端控制器
 * </p>
 *
 * @author renchao
 * @since 2021-04-25
 */
@Api(tags = "样品化验-送验单分析结果")
@RestController
@RequestMapping("/business/t-sample-laboratorysheet")
public class TSampleLaboratorysheetController {

    @Autowired
    private ITSampleLaboratorysheetService itSampleLaboratorysheetService;


    /**
     * 根据样号查看分析结果
     *
     * @return
     */
    @ApiOperation(value = "根据样号查看分析结果")
    @GetMapping(value = "/getByYh/{yh}")
    public R getByYh(@PathVariable @NotBlank String yh) {
        TSampleLaboratorysheetQuery param = new TSampleLaboratorysheetQuery();
        param.setYh(yh);
        return itSampleLaboratorysheetService.getByYh(param);
    }


    /**
     * 根据样号修改分析结果
     *
     * @param tSampleLaboratorysheetQuery
     * @return
     */
    @ApiOperation(value = "根据样号修改分析结果")
    @RequestMapping(value = "/updateByYh", method = RequestMethod.POST)
    public R updateByYh(@RequestBody TSampleLaboratorysheetQuery tSampleLaboratorysheetQuery) {
        return itSampleLaboratorysheetService.updateByYh(tSampleLaboratorysheetQuery);
    }


    /**
     * 根据样号删除分析结果
     *
     * @param tSampleLaboratorysheetQuery
     * @return
     */
    @ApiOperation(value = "根据样号删除分析结果")
    @RequestMapping(value = "/deleteByYh", method = RequestMethod.POST)
    public R deleteByYh(@RequestBody TSampleLaboratorysheetQuery tSampleLaboratorysheetQuery) {
        return itSampleLaboratorysheetService.deleteByYh(tSampleLaboratorysheetQuery);
    }


    /**
     * 增加分析结果
     *
     * @param tSampleLaboratorysheetQuery
     * @return
     */
    @ApiOperation(value = "增加分析结果")
    @RequestMapping(value = "/insertTSampleLaboratorysheet", method = RequestMethod.POST)
    public R insertTSampleLaboratorysheet(@RequestBody TSampleLaboratorysheetQuery tSampleLaboratorysheetQuery) {
        return itSampleLaboratorysheetService.insertTSampleLaboratorysheet(tSampleLaboratorysheetQuery);
    }

    /**
     * 二维码下载
     *
     * @return
     */
    @ApiOperation(value = "二维码下载")
    @ApiImplicitParams(value = {
            @ApiImplicitParam(name = "yh", value = "样号", paramType = "query", dataType = "String")
    })
    @RequestMapping(value = "/getImage", method = RequestMethod.GET)
    public R getImage(String yh,final HttpServletResponse response) {
        TSampleLaboratorysheetQuery param = new TSampleLaboratorysheetQuery();
        param.setYh(yh);
        return itSampleLaboratorysheetService.getImage(param,response);
    }
}

