package cn.wise.sc.acquisition.business.controller;


import cn.wise.sc.acquisition.business.model.query.TSampleListQuery;
import cn.wise.sc.acquisition.business.service.ITSampleListService;
import cn.wise.sc.acquisition.business.wrapper.page.Query;
import com.baomidou.mybatisplus.extension.api.R;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotBlank;

/**
 * <p>
 * 前端控制器
 * </p>
 *
 * @author ztw
 * @since 2021-04-22
 */
@Api(tags = "样品化验-送验单接口")
@RestController
@RequestMapping("/business/t-sample-list")
public class TSampleListController {

    @Autowired
    private ITSampleListService itSampleListService;

    /**
     * 根据条件查询送验单 分页
     *
     * @return
     */
    @ApiOperation(value = "获取送验单列表 可分页模糊查询")
    @ApiImplicitParams(value = {
            @ApiImplicitParam(name = "search", value = "搜索关键字", paramType = "query", dataType = "String")
    })
    @RequestMapping(value = "/getPage", method = RequestMethod.GET)
    public R getPage(Query query, String search) {
        TSampleListQuery param = new TSampleListQuery();
        param.setSearch(search);
        return itSampleListService.getPage(param, query);
    }


    /**
     * 根据样号修改送验单
     *
     * @param tSampleListQuery
     * @return
     */
    @ApiOperation(value = "根据样号修改送验单")
    @RequestMapping(value = "/updateByYh", method = RequestMethod.POST)
    public R updateByYh(@RequestBody TSampleListQuery tSampleListQuery) {
        return itSampleListService.updateByYh(tSampleListQuery);
    }

    /**
     * 增加送验单
     *
     * @param tSampleListQuery
     * @return
     */
    @ApiOperation(value = "增加送验单")
    @RequestMapping(value = "/insertSampleList", method = RequestMethod.POST)
    public R insertSampleList(@RequestBody TSampleListQuery tSampleListQuery) {
        return itSampleListService.insertSampleList(tSampleListQuery);
    }


    /**
     * 根据样号删除送验单
     *
     * @param tSampleListQuery
     * @return
     */
    @ApiOperation(value = "根据样号删除送验单")
    @RequestMapping(value = "/deleteByYh", method = RequestMethod.POST)
    public R deleteByYh(@RequestBody TSampleListQuery tSampleListQuery) {
        return itSampleListService.deleteByYh(tSampleListQuery);
    }


    /**
     * 保存图片
     *
     * @return
     */
//    @ApiOperation(value = "保存图片")
//    @RequestMapping(value = "/saveImage", method = RequestMethod.POST)
//    public R saveImage(TSampleListQuery query, @RequestParam(value = "file", required = true) MultipartFile file) {
//        return itSampleListService.saveImage(query, file);
//    }

    /**
     * 下载图片
     *
     * @return
     */
//    @ApiOperation(value = "下载图片")
//    @GetMapping(value = "/getImage/{yh}" )
//    public R getImage(@PathVariable @NotBlank String yh, final HttpServletResponse response) {
//        TSampleListQuery param = new TSampleListQuery();
//        param.setYh(yh);
//        return itSampleListService.getImage(param, response);
//    }

}

