package cn.wise.sc.acquisition.business.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 
 * </p>
 *
 * @author ztw
 * @since 2021-04-23
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("T_Equipment_Account")
public class TEquipmentAccount implements Serializable {

    private static final long serialVersionUID=1L;

    /**
     * 设备编码
     */
    @TableId("EquipmentID")
    private String EquipmentID;

    /**
     * 设备名称
     */
    @TableField("EquipmentName")
    private String EquipmentName;

    /**
     * 所属工序
     */
    @TableField("ProcessesName")
    private String ProcessesName;

    /**
     * 设备类型，包括租赁和自有
     */
    @TableField("EquipmentType")
    private String EquipmentType;

    /**
     * 机长
     */
    @TableField("EquManager")
    private String EquManager;

    /**
     * 规格型号
     */
    @TableField("Ggxh")
    private String Ggxh;

    /**
     * 生产能力
     */
    @TableField("Scnl")
    private String Scnl;

    /**
     * 装机容量
     */
    @TableField("Zjrl")
    private String Zjrl;

    /**
     * 生产厂家
     */
    @TableField("Sccj")
    private String Sccj;

    /**
     * 出厂日期
     */
    @TableField("Ccrq")
    private LocalDateTime Ccrq;

    /**
     * 出厂编号
     */
    @TableField("Ccbh")
    private String Ccbh;

    /**
     * 耐用年限
     */
    @TableField("Nynx")
    private String Nynx;

    /**
     * 资产编码
     */
    @TableField("Zcbm")
    private String Zcbm;

    /**
     * 设备原值
     */
    @TableField("Yz")
    private Float Yz;

    /**
     * 启用日期
     */
    @TableField("Qyrq")
    private LocalDateTime Qyrq;

    /**
     * 燃料类别
     */
    @TableField("Rllb")
    private String Rllb;

    /**
     * 转速
     */
    @TableField("Zs")
    private String Zs;

    /**
     * 状态,分为在用1和报废0
     */
    @TableField("Sbzt")
    private Boolean Sbzt;

    /**
     * 备注
     */
    @TableField("Bz")
    private String Bz;


}
