package cn.wise.sc.acquisition.business.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 
 * </p>
 *
 * @author ztw
 * @since 2021-04-25
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("T_Equipment_Check")
public class TEquipmentCheck implements Serializable {

    private static final long serialVersionUID=1L;

    /**
     * ID号
     */
    @TableId(value = "Uid", type = IdType.ASSIGN_UUID)
    private String Uid;

    /**
     * 设备编码
     */
    @TableField("EquipmentID")
    private String EquipmentID;

    /**
     * 设备名称
     */
    @TableField("EquipmentName")
    private String EquipmentName;

    /**
     * 点检部位
     */
    @TableField("Djbw")
    private String Djbw;

    /**
     * 点检内容
     */
    @TableField("Djnr")
    private String Djnr;

    /**
     * 点检标准
     */
    @TableField("Djbz")
    private String Djbz;

    /**
     * 点检周期
     */
    @TableField("Djzq")
    private Integer Djzq;

    /**
     * 周期类型,天、月等
     */
    @TableField("Zqlx")
    private String Zqlx;

    /**
     * 点检结果，正常、异常
     */
    @TableField("Djjg")
    private String Djjg;

    /**
     * 异常记录
     */
    @TableField("Ycjl")
    private String Ycjl;

    /**
     * 点检人
     */
    @TableField("Djr")
    private String Djr;

    /**
     * 点检日期
     */
    @TableField("Djrq")
    private LocalDateTime Djrq;


}
