package cn.wise.sc.acquisition.business.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 
 * </p>
 *
 * @author ztw
 * @since 2021-04-25
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("T_Equipment_Run")
public class TEquipmentRun implements Serializable {

    private static final long serialVersionUID=1L;

    @TableId(value = "Uid", type = IdType.ASSIGN_UUID)
    private String Uid;

    /**
     * 设备编码
     */
    @TableField("EquipmentID")
    private String EquipmentID;

    /**
     * 设备名称
     */
    @TableField("EquipmentName")
    private String EquipmentName;

    /**
     * 运行日期
     */
    @TableField("RunDate")
    private LocalDateTime RunDate;

    /**
     * 当天运行时间h
     */
    @TableField("RunHour")
    private Float RunHour;

    /**
     * 当天停机时间
     */
    @TableField("StopHour")
    private Float StopHour;

    /**
     * 停机原因:故障/维修/保养
     */
    @TableField("StopType")
    private String StopType;

    /**
     * 驾驶员/操作人员
     */
    @TableField("Driver")
    private String Driver;

    /**
     * 填写人
     */
    @TableField("Txr")
    private String Txr;

    /**
     * 日期标记,如:2021年01月
     */
    @TableField("Tag")
    private String Tag;


}
