package cn.wise.sc.acquisition.business.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 
 * </p>
 *
 * @author ztw
 * @since 2021-04-25
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("T_Equipment_Trouble")
public class TEquipmentTrouble implements Serializable {

    private static final long serialVersionUID=1L;

    /**
     * ID号
     */
    @TableId(value = "Uid", type = IdType.ASSIGN_UUID)
    private String Uid;

    /**
     * 设备编码
     */
    @TableField("EquipmentID")
    private String EquipmentID;

    /**
     * 设备名称
     */
    @TableField("EquipmentName")
    private String EquipmentName;

    /**
     * 隐患发现人
     */
    @TableField("Fxr")
    private String Fxr;

    /**
     * 隐患发现日期
     */
    @TableField("Fxrq")
    private LocalDateTime Fxrq;

    /**
     * 隐患描述
     */
    @TableField("Yhms")
    private String Yhms;

    /**
     * 隐患处理措施
     */
    @TableField("Clcs")
    private String Clcs;

    /**
     * 隐患处理日期
     */
    @TableField("Clrq")
    private LocalDateTime Clrq;

    /**
     * 是否已修好：1是，0否
     */
    private String clr;

    /**
     * 填报人
     */
    @TableField("Txr")
    private String Txr;

    /**
     * 填报日期
     */
    @TableField("Txrq")
    private LocalDateTime Txrq;

    /**
     * 隐患处理状态：已处理和未处理
     */
    @TableField("Clzt")
    private String Clzt;


}
