package cn.wise.sc.acquisition.business.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 
 * </p>
 *
 * @author renchao
 * @since 2021-04-27
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("T_Material_Entry")
public class TMaterialEntry implements Serializable {

    private static final long serialVersionUID=1L;

    @TableId(value = "Uid", type = IdType.ASSIGN_UUID)
    private String Uid;

    /**
     * 材料类型，包括燃料及动力、润滑察试、配件、工具、火工材料、电力和其它等
     */
    @TableField("Type")
    private String Type;

    /**
     * 本期购入的材料的品名
     */
    @TableField("Name")
    private String Name;

    /**
     * 本期购入的数量
     */
    @TableField("Amount")
    private Float Amount;

    /**
     * 本期购入的单价
     */
    @TableField("Price")
    private Float Price;

    /**
     * 本期购入的金额：AmounMt*PriceM
     */
    @TableField("Total")
    private Float Total;

    /**
     * 材料入库日期
     */
    @TableField("InDate")
    private LocalDateTime InDate;

    /**
     * 材料入库人
     */
    @TableField("InPeopleName")
    private String InPeopleName;


}
