package cn.wise.sc.acquisition.business.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 
 * </p>
 *
 * @author renchao
 * @since 2021-04-27
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("T_Material_Out")
public class TMaterialOut implements Serializable {

    private static final long serialVersionUID=1L;

    /**
     * ID号
     */
    @TableId(value = "Uid", type = IdType.ASSIGN_UUID)
    private String Uid;

    /**
     * 设备编码
     */
    @TableField("EquipmentID")
    private String EquipmentID;

    /**
     * 设备名称
     */
    @TableField("EquipmentName")
    private String EquipmentName;

    /**
     * 工序名称
     */
    @TableField("ProcessesName")
    private String ProcessesName;

    /**
     * 材料消耗的类型，包括燃料及动力、润滑察试、配件、工具、火工材料、电力和其它等
     */
    @TableField("ConsumeType")
    private String ConsumeType;

    /**
     * 材料消耗日期
     */
    @TableField("ConsumeDate")
    private LocalDateTime ConsumeDate;

    /**
     * 消耗材料的品名
     */
    @TableField("Name")
    private String Name;

    /**
     * 消耗材料的数量
     */
    @TableField("Amount")
    private Float Amount;

    /**
     * 消耗材料的单价
     */
    @TableField("Price")
    private Float Price;

    /**
     * 花费的金额：Amount*Price
     */
    @TableField("Total")
    private Float Total;

    /**
     * 用途:生产，保养、维修
     */
    @TableField("Purpose")
    private String Purpose;

    /**
     * 材料发放人
     */
    @TableField("Clffr")
    private String Clffr;

    /**
     * 材料领用人
     */
    @TableField("Cllyr")
    private String Cllyr;

    /**
     * 备注
     */
    @TableField("Bz")
    private String Bz;

    /**
     * 日期标记,如:2021年01月
     */
    @TableField("Tag")
    private String Tag;


}
