package cn.wise.sc.acquisition.business.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;

import java.io.Serializable;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 *
 * </p>
 *
 * @author renchao
 * @since 2021-04-30
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("T_Processes_Auxiliary")
public class TProcessesAuxiliary implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * ID号
     */
    @TableId(value = "Uid", type = IdType.ASSIGN_UUID)
    private String Uid;

    /**
     * 设备编号
     */
    @TableField("EquipmentID")
    private String EquipmentID;

    /**
     * 设备名称
     */
    @TableField("EquipmentName")
    private String EquipmentName;

    /**
     * 项目经理
     */
    @TableField("Manager")
    private String Manager;

    /**
     * 主管项目领导
     */
    @TableField("Supervisor")
    private String Supervisor;

    /**
     * 生产技术部
     */
    @TableField("TechDepart")
    private String TechDepart;

    /**
     * 制表人
     */
    @TableField("Tabulator")
    private String Tabulator;

    /**
     * 当月累计油量
     */
    @TableField("Ljyl")
    private Float Ljyl;

    /**
     * 总价(元)
     */
    @TableField("Zj")
    private Float Zj;

    /**
     * 当月累计产量
     */
    @TableField("Dyljcl")
    private Float Dyljcl;

    /**
     * 单耗=当月累计油量/当月产量
     */
    @TableField("Dh")
    private Double Dh;

    /**
     * 备注
     */
    @TableField("Bz")
    private String Bz;

    /**
     * 日期标记,如:2021年01月
     */
    @TableField("Tag")
    private String Tag;

    /**
     * 司机
     */
    @TableField("Driver")
    private String Driver;

    /**
     * 作业日期
      */
    @TableField("Zyrq")
    private String Zyrq;
}
