package cn.wise.sc.acquisition.business.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;

import java.time.LocalDateTime;

import com.baomidou.mybatisplus.annotation.TableField;

import java.io.Serializable;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 *
 * </p>
 *
 * @author renchao
 * @since 2021-04-27
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("T_Processes_BlastDesign_Hole")
public class TProcessesBlastdesignHole implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * ID号
     */
    @TableId(value = "Uid", type = IdType.ASSIGN_UUID)
    private String Uid;

    /**
     * 采区名称
     */
    @TableField("StopeName")
    private String StopeName;

    /**
     * 平台名称
     */
    @TableField("StepName")
    private String StepName;

    /**
     * 爆区名称
     */
    @TableField("BlastAreaName")
    private String BlastAreaName;

    /**
     * 炮孔编号
     */
    @TableField("BlastHoleID")
    private String BlastHoleID;

    /**
     * 孔深（m）
     */
    @TableField("Depth")
    private Double Depth;

    /**
     * 排距（m）
     */
    @TableField("RowSpace")
    private Double RowSpace;

    /**
     * 孔距（m）
     */
    @TableField("HoleSpace")
    private Double HoleSpace;

    /**
     * 方位角
     */
    @TableField("Azimuth")
    private Double Azimuth;

    /**
     * 倾角
     */
    @TableField("Inclination")
    private Double Inclination;

    /**
     * 孔径(m)
     */
    @TableField("Aperture")
    private Double Aperture;

    /**
     * 开孔坐标X
     */
    @TableField("X")
    private Double x;

    /**
     * 开孔坐标Y
     */
    @TableField("Y")
    private Double y;

    /**
     * 开孔坐标Z
     */
    @TableField("Z")
    private Double z;

    /**
     * 台阶高度
     */
    @TableField("StepHeight")
    private Double StepHeight;

    /**
     * 单孔爆破量(m3)=孔距*排距*台阶高度
     */
    @TableField("HoleBlastVolume")
    private Double HoleBlastVolume;

    /**
     * 穿孔日期
     */
    @TableField("DrillingDate")
    private LocalDateTime DrillingDate;

    /**
     * 设计日期
     */
    @TableField("DesignDate")
    private LocalDateTime DesignDate;

    /**
     * 日期标记,如:2020年11月
     */
    @TableField("Tag")
    private String Tag;

}
