package cn.wise.sc.acquisition.business.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 
 * </p>
 *
 * @author renchao
 * @since 2021-04-30
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("T_Processes_Crusher")
public class TProcessesCrusher implements Serializable {

    private static final long serialVersionUID=1L;

    /**
     * ID号
     */
      @TableId(value = "Uid", type = IdType.ASSIGN_UUID)
    private String Uid;

    /**
     * 破碎站编号
     */
    @TableField("CrusherStationID")
    private String CrusherStationID;

    /**
     * 破碎日期
     */
    @TableField("CrushDate")
    private LocalDateTime CrushDate;

    /**
     * 项目经理
     */
    @TableField("Manager")
    private String Manager;

    /**
     * 主管项目领导
     */
    @TableField("Supervisor")
    private String Supervisor;

    /**
     * 生产技术部
     */
    @TableField("TechDepart")
    private String TechDepart;

    /**
     * 制表人
     */
    @TableField("Tabulator")
    private String Tabulator;

    /**
     * 设备编号
     */
    @TableField("EquipmentID")
    private String EquipmentID;

    /**
     * 工作内容
     */
    @TableField("WorkType")
    private String WorkType;

    /**
     * 工作时间（H）
     */
    @TableField("WorkTime")
    private Float WorkTime;

    /**
     * 完成吨位
     */
    @TableField("Wcdw")
    private Double Wcdw;

    /**
     * 合同单价
     */
    @TableField("Price")
    private Float Price;

    /**
     * 结算金额=Wcdw*Price
     */
    @TableField("TotalMoney")
    private Float TotalMoney;

    /**
     * 备注
     */
    @TableField("Bz")
    private String Bz;

    /**
     * 日期标记,如:2021年01月
     */
    @TableField("Tag")
    private String Tag;


}
