package cn.wise.sc.acquisition.business.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 
 * </p>
 *
 * @author ztw
 * @since 2021-04-28
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("T_Processes_Digging")
public class TProcessesDigging implements Serializable {

    private static final long serialVersionUID=1L;

    /**
     * ID号
     */

    @TableId(value = "Uid", type = IdType.ASSIGN_UUID)
    private String Uid;

    /**
     * 采区名称
     */
    @TableField("StopeName")
    private String StopeName;

    /**
     * 平台名称
     */
    @TableField("StepName")
    private String StepName;

    /**
     * 爆区名称
     */
    @TableField("BlastAreaName")
    private String BlastAreaName;

    /**
     * 装车日期
     */
    @TableField("DigDate")
    private LocalDateTime DigDate;

    /**
     * 项目经理
     */
    @TableField("Manager")
    private String Manager;

    /**
     * 主管项目领导
     */
    @TableField("Supervisor")
    private String Supervisor;

    /**
     * 生产技术部
     */
    @TableField("TechDepart")
    private String TechDepart;

    /**
     * 制表人
     */
    @TableField("Tabulator")
    private String Tabulator;

    /**
     * 挖机编号
     */
    @TableField("EquipmentID")
    private String EquipmentID;

    /**
     * 司机
     */
    @TableField("Driver")
    private String Driver;

    /**
     * 工作内容
     */
    @TableField("WorkType")
    private String WorkType;

    /**
     * 挖机开始读数（H）
     */
    @TableField("StartTime")
    private Float StartTime;

    /**
     * 挖机结束读数（H）
     */
    @TableField("EndTime")
    private Float EndTime;

    /**
     * 挖机工作时间（H）
     */
    @TableField("WorkTime")
    private Float WorkTime;

    /**
     * 完成吨位
     */
    @TableField("Workload")
    private Double Workload;

    /**
     * 备注
     */
    @TableField("Bz")
    private String Bz;

    /**
     * 日期标记,如:2021年01月
     */
    @TableField("Tag")
    private String Tag;


}
