package cn.wise.sc.acquisition.business.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;

import java.time.LocalDateTime;

import com.baomidou.mybatisplus.annotation.TableField;

import java.io.Serializable;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 *
 * </p>
 *
 * @author renchao
 * @since 2021-04-29
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("T_Processes_Drilling")
public class TProcessesDrilling implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * ID号
     */
    @TableId("Uid")
    private String Uid;


    /**
     * 项目经理
     */
    @TableField("Manager")
    private String Manager;

    /**
     * 主管项目领导
     */
    @TableField("Supervisor")
    private String Supervisor;

    /**
     * 生产技术部
     */
    @TableField("TechDepart")
    private String TechDepart;

    /**
     * 制表人
     */
    @TableField("Tabulator")
    private String Tabulator;

    /**
     * 钻机编号
     */
    @TableField("EquipmentID")
    private String EquipmentID;

    /**
     * 司机
     */
    @TableField("Driver")
    private String Driver;

    /**
     * 钻机开始读数（H）
     */
    @TableField("StartTime")
    private Float StartTime;

    /**
     * 钻机结束读数（H）
     */
    @TableField("EndTime")
    private Float EndTime;

    /**
     * 钻机工作时间（H）
     */
    @TableField("WorkTime")
    private Float WorkTime;

    /**
     * 孔深（m）
     */
    @TableField("Depth")
    private Double Depth;

    /**
     * 排距（m）
     */
    @TableField("RowSpace")
    private Double RowSpace;

    /**
     * 孔距（m）
     */
    @TableField("HoleSpace")
    private Double HoleSpace;

    /**
     * 方位角
     */
    @TableField("Azimuth")
    private Double Azimuth;

    /**
     * 倾角
     */
    @TableField("Inclination")
    private Double Inclination;

    /**
     * 孔径(m)
     */
    @TableField("Aperture")
    private Double Aperture;

    /**
     * 开孔坐标X
     */
    @TableField("X")
    private Double x;

    /**
     * 开孔坐标Y
     */
    @TableField("Y")
    private Double y;

    /**
     * 开孔坐标Z
     */
    @TableField("Z")
    private Double z;

    /**
     * 单孔爆破量(m3)
     */
    @TableField("HoleBlastVolume")
    private Double HoleBlastVolume;

    /**
     * 爆破日期
     */
    @TableField("BlastDate")
    private LocalDateTime BlastDate;

    /**
     * 穿孔作业人
     */
    @TableField("Operator")
    private String Operator;

    /**
     * 测量验收人
     */
    @TableField("Accepter")
    private String Accepter;

    /**
     * 备注
     */
    @TableField("Bz")
    private String Bz;

    /**
     * 日期标记,如:2021年01月
     */
    @TableField("Tag")
    private String Tag;


}
