package cn.wise.sc.acquisition.business.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 
 * </p>
 *
 * @author ztw
 * @since 2021-04-26
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("T_Processes_Truck")
public class TProcessesTruck implements Serializable {

    private static final long serialVersionUID=1L;

    /**
     * ID号
     */
    @TableId(value = "Uid", type = IdType.ASSIGN_UUID)
    private String Uid;

    /**
     * 采区名称
     */
    @TableField("StopeName")
    private String StopeName;

    /**
     * 平台名称
     */
    @TableField("StepName")
    private String StepName;

    /**
     * 爆区名称
     */
    @TableField("BlastAreaName")
    private String BlastAreaName;

    /**
     * 运输日期
     */
    @TableField("DeliveryDate")
    private LocalDateTime DeliveryDate;

    /**
     * 项目经理
     */
    @TableField("Manager")
    private String Manager;

    /**
     * 主管项目领导
     */
    @TableField("Supervisor")
    private String Supervisor;

    /**
     * 生产技术部
     */
    @TableField("TechDepart")
    private String TechDepart;

    /**
     * 制表人
     */
    @TableField("Tabulator")
    private String Tabulator;

    /**
     * 矿车编号
     */
    @TableField("TruckID")
    private String TruckID;

    /**
     * 矿车司机
     */
    @TableField("Driver")
    private String Driver;

    /**
     * 挖机编号
     */
    @TableField("ExcavatorID")
    private String ExcavatorID;

    /**
     * 运距
     */
    @TableField("Distance")
    private Float Distance;

    /**
     * 装车内容
     */
    @TableField("WorkType")
    private String WorkType;

    /**
     * 矿车开始读数（H）
     */
    @TableField("StartTime")
    private Float StartTime;

    /**
     * 矿车结束读数（H）
     */
    @TableField("EndTime")
    private Float EndTime;

    /**
     * 矿车工作时间（H）
     */
    @TableField("WorkTime")
    private Float WorkTime;

    /**
     * 车数合计
     */
    @TableField("Cshj")
    private Integer Cshj;

    /**
     * 吨位合计
     */
    @TableField("Dwhj")
    private Double Dwhj;

    /**
     * 吨公里合计
     */
    @TableField("Dglhj")
    private Double Dglhj;

    /**
     * 备注
     */
    @TableField("Bz")
    private String Bz;

    /**
     * 日期标记,如:2021年01月
     */
    @TableField("Tag")
    private String Tag;


}
