package cn.wise.sc.acquisition.business.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 
 * </p>
 *
 * @author renchao
 * @since 2021-04-22
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("T_Sample_List")
public class TSampleList implements Serializable {

    private static final long serialVersionUID=1L;

    /**
     * 样号
     */
    @TableId("Yh")
    private String Yh;

    /**
     * 二维码  因为是字节，很长，不查询这个字段
     */
    @TableField("QRCode")
    private byte[] QRCode;

    /**
     * 采区名称
     */
    @TableField("StopeName")
    private String StopeName;

    /**
     * 平台名称
     */
    @TableField("StepName")
    private String StepName;

    /**
     * 爆区名称
     */
    @TableField("BlastAreaName")
    private String BlastAreaName;

    /**
     * 炮孔编号
     */
    @TableField("HolesID")
    private String HolesID;

    /**
     * 从
     */
    @TableField("Start")
    private String Start;

    /**
     * 至
     */
    @TableField("EndTo")
    private String EndTo;

    /**
     * 送样人
     */
    @TableField("Syr")
    private String Syr;

    /**
     * 送样时间
     */
    @TableField("Syrq")
    private LocalDateTime Syrq;

    /**
     * 备注
     */
    @TableField("Bz")
    private String Bz;

    /**
     * 记录对象
     */
//    @TableField("RecordName")
//    private String RecordName;

    /**
     * 记录形式  因为是字节，很长，不查询这个字段
     */
//    @TableField("RecordCode")
//    private byte[] RecordCode;

    /**
     * 化验室是否已接收，0未接收，1已接收
     */
    @TableField("Flag")
    private byte[] Flag;
}
