package cn.wise.sc.acquisition.business.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 *
 * </p>
 *
 * @author ztw
 * @since 2021-04-26
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("T_Weight")
public class TWeight implements Serializable {

    private static final long serialVersionUID=1L;

    /**
     * ID号
     */
    @TableId("ID")
    private String ID;

    /**
     * 日期 日期=日期+时间
     */
    @TableField("Rq")
    private LocalDateTime Rq;


    /**
     * 矿车编号
     */
    @TableField("TruckID")
    private String TruckID;

    /**
     * 总毛重
     */
    @TableField("Mz")
    private Float Mz;

    /**
     * 总皮重
     */
    @TableField("Pz")
    private Float Pz;

    /**
     * 总净重
     */
    @TableField("Jz")
    private Float Jz;

    /**
     * 日期标记,如:2021年01月
     */
    @TableField("Tag")
    private String Tag;


    /**
     * 毛重时间
     */
    @TableField("Mzsj")
    private LocalDateTime Mzsj;

    /**
     * 皮重时间
     */
    @TableField("Pzsj")
    private LocalDateTime Pzsj;

    /**
     * 操作员
     */
    @TableField("Czy")
    private String Czy;

    /**
     * 台号
     */
    @TableField("Th")
    private String Th;

    /**
     * 出入类型
     */
    @TableField("Crlx")
    private String Crlx;

    /**
     * 备用2
     */
    @TableField("BeiY")
    private String BeiY;

    /**
     * 收货
     */
    @TableField("Sh")
    private String Sh;

    /**
     * 发货
     */
    @TableField("Fh")
    private String Fh;

    /**
     * 货名
     */
    @TableField("Hm")
    private String Hm;

    /**
     * 车号
     */
    @TableField("Ch")
    private String Ch;

    /**
     * 序号
     */
    @TableField("Xh")
    private String Xh;
}
