package cn.wise.sc.acquisition.business.enumation;

import org.apache.commons.lang3.StringUtils;

/**
 *  Author：renchao
 *  送验单模块枚举
 */
public class ProjectEnum {



    /**
     * 很多项目都会共用的字段
     */
    public enum ProcessesType {

        T_PROCESSES_DRILLING(1, "穿孔工序","材料消耗日期"),
        T_PROCESSES_BLAST(2, "爆破工序","工序名称"),
        T_PROCESSES_DIGGING(3, "装车工序","工序名称"),
        T_PROCESSES_TRUCK(4, "运输工序","工序名称"),
        T_PROCESSES_CRUSHER(5, "破碎工序","工序名称"),
        T_PROCESSES_AUXILIARY(6, "辅助工序","工序名称");


        // 成员变量
        private int value;
        private String label;
        private String explain;

        // 构造方法
        ProcessesType(int value, String label, String explain) {
            this.value = value;
            this.label = label;
            this.explain = explain;
        }

        /**
         * 根据value,获取label
         */
        public static String getLabel(int value) {
            for (ProcessesType c : ProcessesType.values()) {
                if (c.value == value) {
                    return c.label;
                }
            }
            return ProcessesType.T_PROCESSES_DRILLING.label;
        }

        /**
         * 根据label,获取value
         */
        public static int getValue(String label) {
            for (ProcessesType c : ProcessesType.values()) {
                if (StringUtils.equalsIgnoreCase(label, c.label)) {
                    return c.value;
                }
            }
            return ProcessesType.T_PROCESSES_DRILLING.value;
        }

        public int getValue() {
            return value;
        }

        public String getLabel() {
            return label;
        }
    }


    /**
     * 很多项目都会共用的字段
     */
    public enum TMaterialOut {


        CONSUME_DATE(1, "ConsumeDate","材料消耗日期"),

        PROCESSES_NAME(2, "ProcessesName","工序名称");


        // 成员变量
        private int value;
        private String label;
        private String explain;

        // 构造方法
        TMaterialOut(int value, String label, String explain) {
            this.value = value;
            this.label = label;
            this.explain = explain;
        }

        /**
         * 根据value,获取label
         */
        public static String getLabel(int value) {
            for (TMaterialOut c : TMaterialOut.values()) {
                if (c.value == value) {
                    return c.label;
                }
            }
            return TMaterialOut.CONSUME_DATE.label;
        }

        /**
         * 根据label,获取value
         */
        public static int getValue(String label) {
            for (TMaterialOut c : TMaterialOut.values()) {
                if (StringUtils.equalsIgnoreCase(label, c.label)) {
                    return c.value;
                }
            }
            return TMaterialOut.CONSUME_DATE.value;
        }

        public int getValue() {
            return value;
        }

        public String getLabel() {
            return label;
        }
    }



    /**
     * 保存图片类型判断 1.记录形式 2.二维码
     */
    public enum ImageType {

        RECORD_CODE(1, "RecordCode","记录形式"),

        QR_CODE(2, "QRCode","二维码");


        // 成员变量
        private int value;
        private String label;
        private String explain;

        // 构造方法
        ImageType(int value, String label, String explain) {
            this.value = value;
            this.label = label;
            this.explain = explain;
        }

        /**
         * 根据value,获取label
         */
        public static String getLabel(int value) {
            for (ImageType c : ImageType.values()) {
                if (c.value == value) {
                    return c.label;
                }
            }
            return ImageType.RECORD_CODE.label;
        }

        /**
         * 根据label,获取value
         */
        public static int getValue(String label) {
            for (ImageType c : ImageType.values()) {
                if (StringUtils.equalsIgnoreCase(label, c.label)) {
                    return c.value;
                }
            }
            return ImageType.RECORD_CODE.value;
        }

        public int getValue() {
            return value;
        }

        public String getLabel() {
            return label;
        }
    }



    /**
     * 保存图片类型判断 1.记录形式 2.二维码
     */
    public enum TSampleListType {


        YH(1, "Yh","样号"),
        HOLES_ID(2, "HolesID","炮孔编号"),
        QR_CODE(2, "QRCode","二维码"),
        STOPE_NAME(2, "StopeName","采区名称"),
        STEP_NAME(3, "StepName","平台名称"),
        BLAST_AREA_NAME(4, "BlastAreaName","爆区名称"),
        START(4, "Start","从"),
        END_TO(4, "EndTo","至"),
        SYR(4, "Syr","送样人"),
        SYRQ(4, "Syrq","送样时间"),
        BZ(4, "Bz","备注"),
        RECORD_NAME(4, "RecordName","记录对象"),
        RECORD_CODE(4, "RecordCode","记录形式");


        // 成员变量
        private int value;
        private String label;
        private String explain;

        // 构造方法
        TSampleListType(int value, String label, String explain) {
            this.value = value;
            this.label = label;
            this.explain = explain;
        }

        /**
         * 根据value,获取label
         */
        public static String getLabel(int value) {
            for (TSampleListType c : TSampleListType.values()) {
                if (c.value == value) {
                    return c.label;
                }
            }
            return TSampleListType.YH.label;
        }

        /**
         * 根据label,获取value
         */
        public static int getValue(String label) {
            for (TSampleListType c : TSampleListType.values()) {
                if (StringUtils.equalsIgnoreCase(label, c.label)) {
                    return c.value;
                }
            }
            return TSampleListType.YH.value;
        }

        public int getValue() {
            return value;
        }

        public String getLabel() {
            return label;
        }
    }


    /**
     * 数据库别名字段 例如select * from TProcessesBlastdesignVolume b,会在queryWrapper中用到
     */
    public enum TableAlias {

        A(1, "a.","别名a"),

        B(2, "b.","别名b");

        // 成员变量
        private int value;
        private String label;
        private String explain;

        // 构造方法
        TableAlias(int value, String label, String explain) {
            this.value = value;
            this.label = label;
            this.explain = explain;
        }

        /**
         * 根据value,获取label
         */
        public static String getLabel(int value) {
            for (TableAlias c : TableAlias.values()) {
                if (c.value == value) {
                    return c.label;
                }
            }
            return TableAlias.A.label;
        }

        /**
         * 根据label,获取value
         */
        public static int getValue(String label) {
            for (TableAlias c : TableAlias.values()) {
                if (StringUtils.equalsIgnoreCase(label, c.label)) {
                    return c.value;
                }
            }
            return TableAlias.A.value;
        }

        public int getValue() {
            return value;
        }

        public String getLabel() {
            return label;
        }

        public String getexplain() {
            return explain;
        }
    }



    /**
     * 数据库别名字段 例如select * from TProcessesBlastdesignVolume b,会在queryWrapper中用到
     */
    public enum TSysDict {

        ID(0, "ID","ID"),

        SIX(6, "6","id为6的数据");

        // 成员变量
        private int value;
        private String label;
        private String explain;

        // 构造方法
        TSysDict(int value, String label, String explain) {
            this.value = value;
            this.label = label;
            this.explain = explain;
        }

        /**
         * 根据value,获取label
         */
        public static String getLabel(int value) {
            for (TSysDict c : TSysDict.values()) {
                if (c.value == value) {
                    return c.label;
                }
            }
            return TSysDict.SIX.label;
        }

        /**
         * 根据label,获取value
         */
        public static int getValue(String label) {
            for (TSysDict c : TSysDict.values()) {
                if (StringUtils.equalsIgnoreCase(label, c.label)) {
                    return c.value;
                }
            }
            return TSysDict.SIX.value;
        }

        public int getValue() {
            return value;
        }

        public String getLabel() {
            return label;
        }

        public String getexplain() {
            return explain;
        }
    }

    /**
     * 数据库别名字段 例如select * from TProcessesBlastdesignVolume b,会在queryWrapper中用到
     */
    public enum TWeight {

        JZ(1, "Jz","净重"),

        RQ(2, "Rq","日期");


        // 成员变量
        private int value;
        private String label;
        private String explain;

        // 构造方法
        TWeight(int value, String label, String explain) {
            this.value = value;
            this.label = label;
            this.explain = explain;
        }

        /**
         * 根据value,获取label
         */
        public static String getLabel(int value) {
            for (TWeight c : TWeight.values()) {
                if (c.value == value) {
                    return c.label;
                }
            }
            return TWeight.JZ.label;
        }

        /**
         * 根据label,获取value
         */
        public static int getValue(String label) {
            for (TWeight c : TWeight.values()) {
                if (StringUtils.equalsIgnoreCase(label, c.label)) {
                    return c.value;
                }
            }
            return TWeight.JZ.value;
        }

        public int getValue() {
            return value;
        }

        public String getLabel() {
            return label;
        }

        public String getexplain() {
            return explain;
        }
    }


    /**
     * 炮孔设计模块业务枚举
     */
    public enum TProcessesBlastdesignVolume {

        DESIGN_DATE(1, "DesignDate","设计时间"),
        STOPE_NAME(2, "StopeName","采区名称"),
        STEP_NAME(3, "StepName","平台名称"),
        BLAST_AREA_NAME(4, "BlastAreaName","爆区名称"),
        DEPTH(5, "Depth","孔深");

        // 成员变量
        private int value;
        private String label;
        private String explain;

        // 构造方法
        TProcessesBlastdesignVolume(int value, String label, String explain) {
            this.value = value;
            this.label = label;
            this.explain = explain;
        }

        /**
         * 根据value,获取label
         */
        public static String getLabel(int value) {
            for (TProcessesBlastdesignVolume c : TProcessesBlastdesignVolume.values()) {
                if (c.value == value) {
                    return c.label;
                }
            }
            return TProcessesBlastdesignVolume.DESIGN_DATE.label;
        }

        /**
         * 根据value,获取tableAlias
         */
        public static String getExplain(int value) {
            for (TProcessesBlastdesignVolume c : TProcessesBlastdesignVolume.values()) {
                if (c.value == value) {
                    return c.explain;
                }
            }
            return TProcessesBlastdesignVolume.DESIGN_DATE.label;
        }

        /**
         * 根据label,获取value
         */
        public static int getValue(String label) {
            for (TProcessesBlastdesignVolume c : TProcessesBlastdesignVolume.values()) {
                if (StringUtils.equalsIgnoreCase(label, c.label)) {
                    return c.value;
                }
            }
            return TProcessesBlastdesignVolume.DESIGN_DATE.value;
        }



        public int getValue() {
            return value;
        }

        public String getLabel() {
            return label;
        }

        public String getexplain() {
            return explain;
        }
    }


    /**
     * 炮孔设计模块业务枚举
     */
    public enum TMineStope {


        STOPE_NAME(1, "StopeName","采区名称"),
        STEP_NAME(2, "StepName","平台名称"),
        BLAST_AREA_NAME(3, "BlastAreaName","爆区名称"),
        IS_USING(4, "IsUsing","是否使用"),
        USING(5, "1","使用"),
        NOT_USING(6, "0","未使用");

        // 成员变量
        private int value;
        private String label;
        private String explain;

        // 构造方法
        TMineStope(int value, String label, String explain) {
            this.value = value;
            this.label = label;
            this.explain = explain;
        }

        /**
         * 根据value,获取label
         */
        public static String getLabel(int value) {
            for (TMineStope c : TMineStope.values()) {
                if (c.value == value) {
                    return c.label;
                }
            }
            return TMineStope.STOPE_NAME.label;
        }

        /**
         * 根据value,获取tableAlias
         */
        public static String getExplain(int value) {
            for (TMineStope c : TMineStope.values()) {
                if (c.value == value) {
                    return c.explain;
                }
            }
            return TMineStope.STOPE_NAME.label;
        }

        /**
         * 根据label,获取value
         */
        public static int getValue(String label) {
            for (TMineStope c : TMineStope.values()) {
                if (StringUtils.equalsIgnoreCase(label, c.label)) {
                    return c.value;
                }
            }
            return TMineStope.STOPE_NAME.value;
        }



        public int getValue() {
            return value;
        }

        public String getLabel() {
            return label;
        }

        public String getexplain() {
            return explain;
        }
    }


    /**
     * 炮孔设计模块业务枚举
     */
    public enum TProcessesBlastdesignHole {

        UID(0, "Uid","uid"),
        STOPE_NAME(1, "StopeName","采区名称"),
        STEP_NAME(2, "StepName","平台名称"),
        Blast_Area_Name(3, "BlastAreaName","爆区名称"),
        BLAST_HOLE_ID(4, "BlastHoleID","炮孔编号"),
        DEPTH(5, "Depth","孔深（m）"),
        ROW_SPACE(6, "RowSpace","排距（m）"),
        HOLE_SPACE(7, "HoleSpace","孔距（m）"),
        AZIMUTH(8, "Azimuth","方位角"),
        INCLINATION(9, "Inclination","倾角"),
        APERTURE(10, "Aperture","孔径(m)"),
        X(11, "x","开孔坐标X"),
        Y(12, "y","开孔坐标Y"),
        Z(13, "z","开孔坐标Z"),
        STEP_HEIGHT(14, "StepHeight","台阶高度"),
        HOLE_BLAST_VOLUME(15, "HoleBlastVolume","单孔爆破量(m3)=孔距*排距*台阶高度"),
        DRILLING_DATE(16, "DrillingDate","穿孔日期"),
        BLAST_DATE(17, "BlastDate","爆破日期"),
        BLAST_VOLUME(18, "BlastVolume","设计爆区爆破量(m3)"),
        DESIGN_DATE(19, "DesignDate","设计日期");


        // 成员变量
        private int value;
        private String label;
        private String explain;

        // 构造方法
        TProcessesBlastdesignHole(int value, String label, String explain) {
            this.value = value;
            this.label = label;
            this.explain = explain;
        }

        /**
         * 根据value,获取label
         */
        public static String getLabel(int value) {
            for (TProcessesBlastdesignHole c : TProcessesBlastdesignHole.values()) {
                if (c.value == value) {
                    return c.label;
                }
            }
            return TProcessesBlastdesignHole.UID.label;
        }

        /**
         * 根据value,获取tableAlias
         */
        public static String getExplain(int value) {
            for (TProcessesBlastdesignHole c : TProcessesBlastdesignHole.values()) {
                if (c.value == value) {
                    return c.explain;
                }
            }
            return TProcessesBlastdesignHole.UID.label;
        }

        /**
         * 根据label,获取value
         */
        public static int getValue(String label) {
            for (TProcessesBlastdesignHole c : TProcessesBlastdesignHole.values()) {
                if (StringUtils.equalsIgnoreCase(label, c.label)) {
                    return c.value;
                }
            }
            return TProcessesBlastdesignHole.UID.value;
        }



        public int getValue() {
            return value;
        }

        public String getLabel() {
            return label;
        }

        public String getexplain() {
            return explain;
        }
    }



    /**
     * TProcessesBlast 枚举
     */
    public enum TProcessesBlast {


        UID(1, "Uid","uid"),

        DESIGN_DEPTH(2, "DesignDepth","设计孔深"),

        HOLE_BLAST_VOLUME(3, "HoleBlastVolume","单孔爆破量"),

        DEPTH(4, "Depth","实测孔深"),

        HOLE_ID(5, "HoleID","炮孔编号"),

        BLAST_DATE(6, "BlastDate","别名a");


        // 成员变量
        private int value;
        private String label;
        private String explain;

        // 构造方法
        TProcessesBlast(int value, String label, String explain) {
            this.value = value;
            this.label = label;
            this.explain = explain;
        }

        /**
         * 根据value,获取label
         */
        public static String getLabel(int value) {
            for (TProcessesBlast c : TProcessesBlast.values()) {
                if (c.value == value) {
                    return c.label;
                }
            }
            return TProcessesBlast.BLAST_DATE.label;
        }

        /**
         * 根据label,获取value
         */
        public static int getValue(String label) {
            for (TProcessesBlast c : TProcessesBlast.values()) {
                if (StringUtils.equalsIgnoreCase(label, c.label)) {
                    return c.value;
                }
            }
            return TProcessesBlast.BLAST_DATE.value;
        }

        public int getValue() {
            return value;
        }

        public String getLabel() {
            return label;
        }

        public String getexplain() {
            return explain;
        }
    }




    /**
     * 保存图片类型判断 1.记录形式 2.二维码
     */
    public enum TProcessesDrilling {

        UID(1, "Uid","Uid"),
        DRILLING_DATE(2, "DrillingDate","穿孔日期"),
        DEPTH(3, "Depth","孔深"),
        ROW_SPACE(4, "RowSpace","排距（m）"),
        HOLE_SPACE(5, "HoleSpace","孔距（m）"),
        DESIGN_DEPTH(6, "DesignDepth","设计孔深（m）"),
        DESIGN_ROW_SPACE(7, "DesignRowSpace","设计排距（m）"),
        DESIGN_HOLE_SPACE(8, "DesignHoleSpace","设计孔距（m）"),
        STEP_HEIGHT(9, "StepHeight","台阶高度"),
        HOLE_BLAST_VOLUME(10, "HoleBlastVolume","单孔爆破量"),
        BLAST_DATE(11, "BlastDate","爆破日期"),
        HOLE_ID(12, "HoleID","炮孔编号");

        // 成员变量
        private int value;
        private String label;
        private String explain;

        // 构造方法
        TProcessesDrilling(int value, String label, String explain) {
            this.value = value;
            this.label = label;
            this.explain = explain;
        }

        /**
         * 根据value,获取label
         */
        public static String getLabel(int value) {
            for (TProcessesDrilling c : TProcessesDrilling.values()) {
                if (c.value == value) {
                    return c.label;
                }
            }
            return TProcessesDrilling.DRILLING_DATE.label;
        }

        /**
         * 根据label,获取value
         */
        public static int getValue(String label) {
            for (TProcessesDrilling c : TProcessesDrilling.values()) {
                if (StringUtils.equalsIgnoreCase(label, c.label)) {
                    return c.value;
                }
            }
            return TProcessesDrilling.DRILLING_DATE.value;
        }

        public int getValue() {
            return value;
        }

        public String getLabel() {
            return label;
        }
    }


    /**
     * 辅助工序字典
     * */
    public enum TProcessesAuxiliary {
        UID(1, "Uid","id"),
        EQUIPMENT_ID(2, "EquipmentID","设备编号"),
        EQUIPMENT_NAME(3, "EquipmentName","设备名称"),
        MANAGER(4, "Manager","项目经理"),
        SUPERVISOR(5, "Supervisor","主管项目领导"),
        TECH_DEPART(6, "TechDepart","生产技术部"),
        TABULATOR(7, "Tabulator","制表人"),
        LJYL(8, "Ljyl","当月累计油量"),
        ZJ(9, "Zj","总价(元)"),
        DYLJCL(10, "Dyljcl","当月累计产量"),
        DH(11, "Dh","单耗=当月累计油量/当月产量"),
        BZ(12, "Bz","备注"),
        DRIVER(13, "Driver","司机"),
        TAG(14, "Tag","日期标记,如:2021年01月");


        // 成员变量
        private int value;
        private String label;
        private String explain;

        // 构造方法
        TProcessesAuxiliary(int value, String label, String explain) {
            this.value = value;
            this.label = label;
            this.explain = explain;
        }

        /**
         * 根据value,获取label
         */
        public static String getLabel(int value) {
            for (TProcessesAuxiliary c : TProcessesAuxiliary.values()) {
                if (c.value == value) {
                    return c.label;
                }
            }
            return TProcessesAuxiliary.EQUIPMENT_ID.label;
        }

        /**
         * 根据label,获取value
         */
        public static int getValue(String label) {
            for (TProcessesAuxiliary c : TProcessesAuxiliary.values()) {
                if (StringUtils.equalsIgnoreCase(label, c.label)) {
                    return c.value;
                }
            }
            return TProcessesAuxiliary.EQUIPMENT_ID.value;
        }

        public int getValue() {
            return value;
        }

        public String getLabel() {
            return label;
        }
    }


    /**
     * 辅助工序字典
     * */
    public enum TProcessesCrusher {

        UID(1, "Uid","id"),
        EQUIPMENT_ID(2, "EquipmentID","设备编号");


        // 成员变量
        private int value;
        private String label;
        private String explain;

        // 构造方法
        TProcessesCrusher(int value, String label, String explain) {
            this.value = value;
            this.label = label;
            this.explain = explain;
        }

        /**
         * 根据value,获取label
         */
        public static String getLabel(int value) {
            for (TProcessesCrusher c : TProcessesCrusher.values()) {
                if (c.value == value) {
                    return c.label;
                }
            }
            return TProcessesCrusher.EQUIPMENT_ID.label;
        }

        /**
         * 根据label,获取value
         */
        public static int getValue(String label) {
            for (TProcessesCrusher c : TProcessesCrusher.values()) {
                if (StringUtils.equalsIgnoreCase(label, c.label)) {
                    return c.value;
                }
            }
            return TProcessesCrusher.EQUIPMENT_ID.value;
        }

        public int getValue() {
            return value;
        }

        public String getLabel() {
            return label;
        }
    }


    /**
     * 员工上班统计表
     */
    public enum TMineWorkemployees {

        UID(1, "Uid","uid"),

        GZSJ(2, "Gzsj","上班日期");

        // 成员变量
        private int value;
        private String label;
        private String explain;

        // 构造方法
        TMineWorkemployees(int value, String label, String explain) {
            this.value = value;
            this.label = label;
            this.explain = explain;
        }

        /**
         * 根据value,获取label
         */
        public static String getLabel(int value) {
            for (TMineWorkemployees c : TMineWorkemployees.values()) {
                if (c.value == value) {
                    return c.label;
                }
            }
            return TMineWorkemployees.GZSJ.label;
        }

        /**
         * 根据label,获取value
         */
        public static int getValue(String label) {
            for (TMineWorkemployees c : TMineWorkemployees.values()) {
                if (StringUtils.equalsIgnoreCase(label, c.label)) {
                    return c.value;
                }
            }
            return TMineWorkemployees.GZSJ.value;
        }

        public int getValue() {
            return value;
        }

        public String getLabel() {
            return label;
        }

        public String getexplain() {
            return explain;
        }
    }

}
