package cn.wise.sc.acquisition.business.model;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Date;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class Message implements Serializable {

	private static final long serialVersionUID = 8508882582940066562L;
	@ApiModelProperty("接收人id")
	private String userId;
	@ApiModelProperty("接收信息")
	private String message;
	@ApiModelProperty("消息类型: 1个人报销，2对公收付款")
	private Integer messageType;
	@ApiModelProperty("相关对象表id(个人报销表或对公收付款表)")
	private Integer appId;
	@ApiModelProperty("发送时间")
	private LocalDateTime createTime;

}
