package cn.wise.sc.acquisition.business.model.query;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * <p>
 * 
 * </p>
 *
 * @author ztw
 * @since 2021-04-25
 */
@Data
@ApiModel("设备运行Query")
public class TEquipmentRunQuery {


    /**
     * ID号
     */
    @ApiModelProperty("Uid")
    private String uid;

    /**
     * 设备编码
     */
    @ApiModelProperty("设备编码")
    private String equipmentID;

    /**
     * 设备名称
     */
    @ApiModelProperty("设备名称")
    private String equipmentName;


    /**
     * 运行日期
     */
    @ApiModelProperty("运行时间")
    private LocalDateTime runDate;

    /**
     *
     */
    @ApiModelProperty("当天运行时间h")
    private Float runHour;

    /**
     * 当天停机时间
     */
    @ApiModelProperty("当天停机时间")
    private Float stopHour;

    /**
     * 停机原因:故障/维修/保养
     */
    @ApiModelProperty("停机原因:故障/维修/保养")
    private String stopType;

    /**
     * 驾驶员/操作人员
     */
    @ApiModelProperty("驾驶员/操作人员")
    private String driver;

    /**
     * 填写人
     */
    @ApiModelProperty("填写人")
    private String txr;

    /**
     * 日期标记,如:2021年01月
     */
    @ApiModelProperty("日期标记,如:2021年01月")
    private String tag;







}
