package cn.wise.sc.acquisition.business.model.query;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * <p>
 * 
 * </p>
 *
 * @author ztw
 * @since 2021-04-25
 */
@Data
@ApiModel("设备隐患Query")
public class TEquipmentTroubleQuery {


    /**
     * ID号
     */
    @ApiModelProperty("Uid")
    private String uid;

    /**
     * 设备编码
     */
    @ApiModelProperty("设备编码")
    private String equipmentID;

    /**
     * 设备名称
     */
    @ApiModelProperty("设备名称")
    private String equipmentName;



    /**
     * 隐患发现人
     */
    @ApiModelProperty("隐患发现人")
    private String fxr;

    /**
     * 隐患发现日期
     */
    @ApiModelProperty("隐患发现日期")
    private LocalDateTime fxrq;

    /**
     * 隐患描述
     */
    @ApiModelProperty("隐患描述")
    private String yhms;

    /**
     * 隐患处理措施
     */
    @ApiModelProperty("隐患处理措施")
    private String clcs;

    /**
     * 隐患处理日期
     */
    @ApiModelProperty("隐患处理日期")
    private LocalDateTime clrq;

    /**
     * 是否已修好：1是，0否
     */
    @ApiModelProperty("是否已修好：1是，0否")
    private String clr;

    /**
     * 填报人
     */
    @ApiModelProperty("填报人")
    private String txr;

    /**
     * 填报日期
     */
    @ApiModelProperty("填报日期")
    private LocalDateTime txrq;

    /**
     * 隐患处理状态：已处理和未处理
     */
    @ApiModelProperty("隐患处理状态：已处理和未处理")
    private String clzt;






}
