package cn.wise.sc.acquisition.business.model.query;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * <p>
 * 
 * </p>
 *
 * @author ztw
 * @since 2021-04-27
 */
@Data
@ApiModel("存货出库Query")
public class TMaterialOutQuery {

    /**
     * ID号
     */
    @ApiModelProperty("出库表id")
    private String uid;

    /**
     * 设备编码
     */
    @ApiModelProperty("设备编码")
    private String equipmentID;

    /**
     * 设备名称
     */
    @ApiModelProperty("设备名称")
    private String equipmentName;

    /**
     * 工序名称
     */
    @ApiModelProperty("工序名称")
    private String processesName;

    /**
     * 材料消耗的类型，包括燃料及动力、润滑察试、配件、工具、火工材料、电力和其它等   ==== 项目
     */
    @ApiModelProperty("材料消耗的类型，包括燃料及动力、润滑察试、配件、工具、火工材料、电力和其它等")
    private String consumeType;

    /**
     * 材料消耗日期  ====材料领用日期
     */
    @ApiModelProperty("材料消耗日期")
    private LocalDateTime consumeDate;

    /**
     * 消耗材料的品名
     */
    @ApiModelProperty("消耗材料的品名")
    private String name;

    /**
     * 消耗材料的数量
     */
    @ApiModelProperty("消耗材料的数量")
    private Float amount;

    /**
     * 消耗材料的单价
     */
    @ApiModelProperty("消耗材料的单价")
    private Float price;

    /**
     * 花费的金额：Amount*Price
     */
    @ApiModelProperty("花费的金额：Amount*Price")
    private Float total;

    /**
     * 用途:生产，保养、维修
     */
    @ApiModelProperty("用途:生产，保养、维修")
    private String purpose;

    /**
     * 材料发放人
     */
    @ApiModelProperty("材料发放人")
    private String clffr;

    /**
     * 材料领用人
     */
    @ApiModelProperty("材料领用人")
    private String cllyr;

    /**
     * 备注
     */
    @ApiModelProperty("备注")
    private String bz;

    /**
     * 日期标记,如:2021年01月
     */
    @ApiModelProperty("日期标记,如:2021年01月")
    private String tag;


}
