package cn.wise.sc.acquisition.business.model.query;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * <p>
 * 
 * </p>
 *
 * @author renchao
 * @since 2021-04-29
 */
@Data
@ApiModel("爆破工序")
public class TProcessesBlastQuery  {

    /**
     * ID号
     */
    @ApiModelProperty("Uid")
    private String Uid;


    /**
     * 爆破人员
     */
    @ApiModelProperty("BlastPeople")
    private String BlastPeople;

    /**
     * 验孔日期
     */
    @ApiModelProperty("CheckHoleDate")
    private LocalDateTime CheckHoleDate;

    /**
     * 验孔人员
     */
    @ApiModelProperty("CheckHolePeople")
    private String CheckHolePeople;

    /**
     * 项目经理
     */
    @ApiModelProperty("Manager")
    private String Manager;

    /**
     * 主管项目领导
     */
    @ApiModelProperty("Supervisor")
    private String Supervisor;

    /**
     * 生产技术部
     */
    @ApiModelProperty("TechDepart")
    private String TechDepart;

    /**
     * 制表人
     */
    @ApiModelProperty("Tabulator")
    private String Tabulator;

    /**
     * 实测孔深（m）
     */
    @ApiModelProperty("Depth")
    private Double Depth;

    @ApiModelProperty("Bz")
    private String Bz;

    /**
     * 日期标记,如:2020年11月
     */
    @ApiModelProperty("Tag")
    private String Tag;

    /**
     * 设计孔深  来自TProcessesDrilling表
     */
    @ApiModelProperty("设计孔深")
    private Double DesignDepth;



    //表连接字段 炮孔设计表

    /**
     * 采区名称
     */
    @ApiModelProperty("StopeName")
    private String StopeName;

    /**
     * 平台名称
     */
    @ApiModelProperty("StepName")
    private String StepName;

    /**
     * 爆区名称
     */
    @ApiModelProperty("BlastAreaName")
    private String BlastAreaName;

    /**
     * 炮孔编号
     */
    @ApiModelProperty("HoleID")
    private String HoleID;

    /**
     * 单孔爆破量 来自 TProcessesBlastdesignHole
     */
    @ApiModelProperty("单孔爆破量")
    private Double HoleBlastVolume;

    
    //表连接字段，穿孔工序表
    /**
     * 爆破日期
     */
    @ApiModelProperty("BlastDate")
    private LocalDateTime BlastDate;

    //以下为业务增加字段
    /**
     * 炮孔编号 修改新的时候会用的
     */
    @ApiModelProperty("NewHoleID")
    private String NewHoleID;
}
