package cn.wise.sc.acquisition.business.model.query;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * <p>
 * 
 * </p>
 *
 * @author renchao
 * @since 2021-04-27
 */
@Data
@ApiModel("爆破设计表")
public class TProcessesBlastdesignHoleQuery  extends TProcessesBlastdesignVolumeQuery{

    /**
     * ID号
     */
    @ApiModelProperty("ID号")
    private String Uid;

    /**
     * 采区名称
     */
    @ApiModelProperty("采区名称")
    private String StopeName;

    /**
     * 平台名称
     */
    @ApiModelProperty("平台名称")
    private String StepName;

    /**
     * 爆区名称
     */
    @ApiModelProperty("爆区名称")
    private String BlastAreaName;

    /**
     * 炮孔编号
     */
    @ApiModelProperty("炮孔编号")
    private String BlastHoleID;

    /**
     * 孔深（m）
     */
    @ApiModelProperty("孔深（m）")
    private Double Depth;

    /**
     * 排距（m）
     */
    @ApiModelProperty("排距（m）")
    private Double RowSpace;

    /**
     * 孔距（m）
     */
    @ApiModelProperty("孔距（m）")
    private Double HoleSpace;

    /**
     * 方位角
     */
    @ApiModelProperty("方位角")
    private Double Azimuth;

    /**
     * 倾角
     */
    @ApiModelProperty("倾角")
    private Double Inclination;

    /**
     * 孔径(m)
     */
    @ApiModelProperty("孔径(m)")
    private Double Aperture;

    /**
     * 开孔坐标X
     */
    @ApiModelProperty("开孔坐标X")
    private Double x;

    /**
     * 开孔坐标Y
     */
    @ApiModelProperty("开孔坐标Y")
    private Double y;

    /**
     * 开孔坐标Z
     */
    @ApiModelProperty("开孔坐标Z")
    private Double z;

    /**
     * 台阶高度
     */
    @ApiModelProperty("台阶高度")
    private Double StepHeight;

    /**
     * 单孔爆破量(m3)=孔距*排距*台阶高度
     */
    @ApiModelProperty("单孔爆破量(m3)=孔距*排距*台阶高度")
    private Double HoleBlastVolume;

    /**
     * 穿孔日期
     */
    @ApiModelProperty("穿孔日期")
    private LocalDateTime DrillingDate;


    //以下为增加字段
    /**
     * 设计爆区爆破量(m3)
     */
    @ApiModelProperty("设计爆区爆破量(m3)")
    private Double BlastVolume;

    /**
     * 设计日期
     */
    @ApiModelProperty("设计日期")
    private LocalDateTime DesignDate;

    //以下为业务增加字段
    /**
     * 炮孔编号 修改新的时候会用的
     */
    @ApiModelProperty("NewBlastHoleID")
    private String NewBlastHoleID;

    /**
     * 日期标记,如:2020年11月
     */
    @ApiModelProperty("Tag")
    private String Tag;
}
