package cn.wise.sc.acquisition.business.model.query;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * <p>
 * 
 * </p>
 *
 * @author ztw
 * @since 2021-04-28
 */
@Data
@ApiModel("装车工序Query")
public class TProcessesDiggingQuery {



    @ApiModelProperty("装车工序表id")
    private String uid;

    /**
     * 采区名称
     */
    @ApiModelProperty("采区名称")
    private String stopeName;

    /**
     * 平台名称
     */
    @ApiModelProperty("平台名称")
    private String stepName;

    /**
     * 爆区名称
     */
    @ApiModelProperty("爆区名称")
    private String blastAreaName;

    /**
     * 装车日期
     */
    @ApiModelProperty("装车日期")
    private LocalDateTime digDate;

    /**
     * 项目经理
     */
    @ApiModelProperty("项目经理")
    private String manager;

    /**
     * 主管项目领导
     */
    @ApiModelProperty("主管项目领导")
    private String supervisor;

    /**
     * 生产技术部
     */
    @ApiModelProperty("生产技术部")
    private String techDepart;

    /**
     * 制表人
     */
    @ApiModelProperty("制表人")
    private String tabulator;

    /**
     * 挖机编号
     */
    @ApiModelProperty("挖机编号")
    private String equipmentID;

    /**
     * 司机
     */
    @ApiModelProperty("司机")
    private String driver;

    /**
     * 工作内容
     */
    @ApiModelProperty("工作内容")
    private String workType;

    /**
     * 挖机开始读数（H）
     */
    @ApiModelProperty("挖机开始读数（H）")
    private Float startTime;

    /**
     * 挖机结束读数（H）
     */
    @ApiModelProperty("挖机结束读数（H）")
    private Float endTime;

    /**
     * 挖机工作时间（H）
     */
    @ApiModelProperty("挖机工作时间（H）")
    private Float workTime;

    /**
     * 完成吨位
     */
    @ApiModelProperty("完成吨位")
    private Double workload;

    /**
     * 备注
     */
    @ApiModelProperty("备注")
    private String bz;

    /**
     * 日期标记,如:2021年01月
     */
    @ApiModelProperty("日期标记,如:2021年01月")
    private String tag;

    

}
