package cn.wise.sc.acquisition.business.model.query;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * <p>
 * 
 * </p>
 *
 * @author ztw
 * @since 2021-04-28
 */
@Data
@ApiModel("运输工序Query")
public class TProcessesTruckQuery {


    /**
     * ID号
     */
    @ApiModelProperty("ID号")
    private String uid;

    /**
     * 采区名称
     */
    @ApiModelProperty("采区名称")
    private String stopeName;

    /**
     * 平台名称
     */
    @ApiModelProperty("平台名称")
    private String stepName;

    /**
     * 爆区名称
     */
    @ApiModelProperty("爆区名称")
    private String blastAreaName;

    /**
     * 运输日期
     */
    @ApiModelProperty("运输日期")
    private LocalDateTime deliveryDate;

    /**
     * 项目经理
     */
    @ApiModelProperty("项目经理")
    private String manager;

    /**
     * 主管项目领导
     */
    @ApiModelProperty("主管项目领导")
    private String supervisor;

    /**
     * 生产技术部
     */
    @ApiModelProperty("生产技术部")
    private String techDepart;

    /**
     * 制表人
     */
    @ApiModelProperty("制表人")
    private String tabulator;

    /**
     * 矿车编号
     */
    @ApiModelProperty("矿车编号")
    private String truckID;

    /**
     * 矿车司机
     */
    @ApiModelProperty("矿车司机")
    private String driver;

    /**
     * 挖机编号
     */
    @ApiModelProperty("挖机编号")
    private String excavatorID;

    /**
     * 运距
     */
    @ApiModelProperty("运距")
    private Float distance;

    /**
     * 装车内容
     */
    @ApiModelProperty("装车内容")
    private String workType;

    /**
     * 矿车开始读数（H）
     */
    @ApiModelProperty("矿车开始读数（H）")
    private Float startTime;

    /**
     * 矿车结束读数（H）
     */
    @ApiModelProperty("矿车结束读数（H）")
    private Float endTime;

    /**
     * 矿车工作时间（H）
     */
    @ApiModelProperty("矿车工作时间（H）")
    private Float workTime;

    /**
     * 车数合计
     */
    @ApiModelProperty("车数合计")
    private Integer cshj;

    /**
     * 吨位合计
     */
    @ApiModelProperty("吨位合计")
    private Double dwhj;

    /**
     * 吨公里合计
     */
    @ApiModelProperty("吨公里合计")
    private Double dglhj;

    /**
     * 备注
     */
    @ApiModelProperty("备注")
    private String bz;

    /**
     * 日期标记,如:2021年01月
     */
    @ApiModelProperty("日期标记,如:2021年01月")
    private String tag;


    

}
