package cn.wise.sc.acquisition.business.model.query;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 
 * </p>
 *
 * @author renchao
 * @since 2021-04-25
 */
@Data
@ApiModel("样品化验单query")
public class TSampleLaboratorysheetQuery {


    /**
     * 样号
     */
    @ApiModelProperty("样号")
    private String Yh;

    /**
     * 二维码
     */
    @ApiModelProperty("二维码")
    private byte[] QRCode;

    /**
     * 化验室编号
     */
    @ApiModelProperty("化验室编号")
    private String LaboratoryID;

    /**
     * 副品存放位置
     */
    @ApiModelProperty("副品存放位置")
    private String Fpcfwz;

    /**
     * 氧化钙
     */
    @ApiModelProperty("氧化钙")
    private Float Cao;

    /**
     * 氧化镁
     */
    @ApiModelProperty("氧化镁")
    private Float MgO;

    /**
     * 三氧化二铝
     */
    @ApiModelProperty("三氧化二铝")
    private Float Al2O3;

    /**
     * 二氧化硅
     */
    @ApiModelProperty("二氧化硅")
    private Float SiO2;

    /**
     * 三氧化二铁
     */
    @ApiModelProperty("三氧化二铁")
    private Float Fe2O3;

    /**
     * 氧化钾
     */
    @ApiModelProperty("氧化钾")
    private Float k2o;

    /**
     * 氧化钠
     */
    @ApiModelProperty("氧化钠")
    private Float Na2O;

    /**
     * 三氧化硫
     */
    @ApiModelProperty("三氧化硫")
    private Float so3;

    /**
     * 氯离子
     */
    @ApiModelProperty("氯离子")
    private Float Cl;

    /**
     * 烧失量
     */
    @ApiModelProperty("烧失量")
    private Float Ssl;

    /**
     * 收样时间
     */
    @ApiModelProperty("收样时间")
    private LocalDateTime Sysj;

    /**
     * 化验人
     */
    @ApiModelProperty("化验人")
    private String Hyr;

    /**
     * 化验时间
     */
    @ApiModelProperty("化验时间")
    private LocalDateTime Hysj;


}
