package cn.wise.sc.acquisition.business.model.query;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;


/**
 * <p>
 *
 * </p>
 *
 * @author ztw
 * @since 2021-04-26
 */
@Data
@ApiModel("地磅称重表")
public class TWeightQuery {


    /**
     * ID号
     */
    @ApiModelProperty("Uid")
    private String Uid;
    /**
     * 日期 日期=日期+时间
     */
    @ApiModelProperty("Rq")
    private LocalDateTime Rq;



    /**
     * 矿车编号
     */
    @ApiModelProperty("TruckID")
    private String TruckID;

    /**
     * 总毛重
     */
    @ApiModelProperty("Mz")
    private Float Mz;

    /**
     * 总皮重
     */
    @ApiModelProperty("Pz")
    private Float Pz;

    /**
     * 总净重
     */
    @ApiModelProperty("Jz")
    private Float Jz;

    /**
     * 日期标记,如:2021年01月
     */
    @ApiModelProperty("Tag")
    private String Tag;


    /**
     * 毛重时间
     */
    @ApiModelProperty("Mzsj")
    private LocalDateTime Mzsj;

    /**
     * 皮重时间
     */
    @ApiModelProperty("Pzsj")
    private LocalDateTime Pzsj;

    /**
     * 操作员
     */
    @ApiModelProperty("Czy")
    private String Czy;

    /**
     * 台号
     */
    @ApiModelProperty("Th")
    private String Th;

    /**
     * 出入类型
     */
    @ApiModelProperty("Crlx")
    private String Crlx;

    /**
     * 备用2
     */
    @ApiModelProperty("BeiY")
    private String BeiY;

    /**
     * 收货
     */
    @ApiModelProperty("Sh")
    private String Sh;

    /**
     * 发货
     */
    @ApiModelProperty("Fh")
    private String Fh;

    /**
     * 货名
     */
    @ApiModelProperty("Hm")
    private String Hm;

    /**
     * 车号
     */
    @ApiModelProperty("Ch")
    private String Ch;

    /**
     * 序号
     */
    @ApiModelProperty("Xh")
    private String Xh;
}
