package cn.wise.sc.acquisition.business.model.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import java.time.LocalDateTime;

/**
 * @description:
 * @author: ztw
 * @create: 2021-04-25
 **/
@Data
@ApiModel("设备点检Vo")
public class TEquipmentCheckVo {

	@ApiModelProperty("Uid")
	private String Uid;

	/**
	 * 设备编码
	 */
	@ApiModelProperty("设备编码")
	private String EquipmentID;

	/**
	 * 设备名称
	 */
	@ApiModelProperty("设备名称")
	private String EquipmentName;

	/**
	 * 点检部位
	 */
	@ApiModelProperty("点检部位")
	private String Djbw;

	/**
	 *
	 */
	@ApiModelProperty("点检内容")
	private String Djnr;

	/**
	 * 点检标准
	 */
	@ApiModelProperty("点检标准")
	private String Djbz;

	/**
	 * 点检周期
	 */
	@ApiModelProperty("点检周期")
	private Integer Djzq;

	/**
	 * 周期类型,天、月等
	 */
	@ApiModelProperty("周期类型,天、月等")
	private String Zqlx;

	/**
	 * 点检结果，正常、异常
	 */
	@ApiModelProperty("点检结果，正常、异常")
	private String Djjg;

	/**
	 * 异常记录
	 */
	@ApiModelProperty("异常记录")
	private String Ycjl;

	/**
	 * 点检人
	 */
	@ApiModelProperty("点检人")
	private String Djr;

	/**
	 * 点检日期
	 */
	@ApiModelProperty("点检日期")
	private LocalDateTime Djrq;


}
