package cn.wise.sc.acquisition.business.model.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * @description:
 * @author: ztw
 * @create: 2021-04-25
 **/
@Data
@ApiModel("设备运行Vo")
public class TEquipmentRunVo {


	@ApiModelProperty("Uid")
	private String Uid;

	/**
	 * 设备编码
	 */
	@ApiModelProperty("设备编码")
	private String EquipmentID;

	/**
	 * 设备名称
	 */
	@ApiModelProperty("设备名称")
	private String EquipmentName;

	/**
	 * 运行日期
	 */
	@ApiModelProperty("运行日期")
	private LocalDateTime RunDate;

	/**
	 *
	 */
	@ApiModelProperty("当天运行时间h")
	private Float RunHour;

	/**
	 * 当天停机时间
	 */
	@ApiModelProperty("StopHour")
	private Float StopHour;

	/**
	 * 停机原因:故障/维修/保养
	 */
	@ApiModelProperty("StopType")
	private String StopType;

	/**
	 * 驾驶员/操作人员
	 */
	@ApiModelProperty("Driver")
	private String Driver;

	/**
	 * 填写人
	 */
	@ApiModelProperty("Txr")
	private String Txr;

	/**
	 * 日期标记,如:2021年01月
	 */
	@ApiModelProperty("Tag")
	private String Tag;

	


}
