package cn.wise.sc.acquisition.business.model.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * @description:
 * @author: ztw
 * @create: 2021-04-25
 **/
@Data
@ApiModel("设备隐患Vo")
public class TEquipmentTroubleVo {


	@ApiModelProperty("Uid")
	private String Uid;

	/**
	 * 设备编码
	 */
	@ApiModelProperty("设备编码")
	private String EquipmentID;

	/**
	 * 设备名称
	 */
	@ApiModelProperty("设备名称")
	private String EquipmentName;


	/**
	 * 隐患发现人
	 */
	@ApiModelProperty("隐患发现人")
	private String Fxr;

	/**
	 * 隐患发现日期
	 */
	@ApiModelProperty("隐患发现日期")
	private LocalDateTime Fxrq;

	/**
	 * 隐患描述
	 */
	@ApiModelProperty("隐患描述")
	private String Yhms;

	/**
	 * 隐患处理措施
	 */
	@ApiModelProperty("隐患处理措施")
	private String Clcs;

	/**
	 * 隐患处理日期
	 */
	@ApiModelProperty("隐患处理日期")
	private LocalDateTime Clrq;

	/**
	 * 是否已修好：1是，0否
	 */
	@ApiModelProperty("是否已修好：1是，0否")
	private String clr;

	/**
	 * 填报人
	 */
	@ApiModelProperty("填报人")
	private String Txr;

	/**
	 * 填报日期
	 */
	@ApiModelProperty("填报日期")
	private LocalDateTime Txrq;

	/**
	 * 隐患处理状态：已处理和未处理
	 */
	@ApiModelProperty("隐患处理状态：已处理和未处理")
	private String Clzt;

	


}
