package cn.wise.sc.acquisition.business.model.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * <p>
 * 
 * </p>
 *
 * @author renchao
 * @since 2021-04-30
 */
@Data
@ApiModel("破碎工序")
public class TProcessesCrusherVo  extends TWeightVo{


    /**
     * ID号
     */
    @ApiModelProperty("Uid")
    private String Uid;

    /**
     * 破碎站编号
     */
    @ApiModelProperty("CrusherStationID")
    private String CrusherStationID;

    /**
     * 破碎日期
     */
    @ApiModelProperty("CrushDate")
    private LocalDateTime CrushDate;

    /**
     * 项目经理
     */
    @ApiModelProperty("Manager")
    private String Manager;

    /**
     * 主管项目领导
     */
    @ApiModelProperty("Supervisor")
    private String Supervisor;

    /**
     * 生产技术部
     */
    @ApiModelProperty("TechDepart")
    private String TechDepart;

    /**
     * 制表人
     */
    @ApiModelProperty("Tabulator")
    private String Tabulator;

    /**
     * 设备编号
     */
    @ApiModelProperty("EquipmentID")
    private String EquipmentID;

    /**
     * 工作内容
     */
    @ApiModelProperty("WorkType")
    private String WorkType;

    /**
     * 工作时间（H）
     */
    @ApiModelProperty("WorkTime")
    private Float WorkTime;

    /**
     * 完成吨位
     */
    @ApiModelProperty("Wcdw")
    private Double Wcdw;

    /**
     * 合同单价
     */
    @ApiModelProperty("Price")
    private Float Price;

    /**
     * 结算金额=Wcdw*Price
     */
    @ApiModelProperty("TotalMoney")
    private Float TotalMoney;

    /**
     * 备注
     */
    @ApiModelProperty("Bz")
    private String Bz;

    /**
     * 日期标记,如:2021年01月
     */
    @ApiModelProperty("Tag")
    private String Tag;


}
