package cn.wise.sc.acquisition.business.model.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * <p>
 * 
 * </p>
 *
 * @author renchao
 * @since 2021-04-29
 */
@Data
@ApiModel("穿孔工序")
public class TProcessesDrillingVo {


    /**
     * ID号
     */
    @ApiModelProperty("Uid")
    private String Uid;

    /**
     * 项目经理
     */
     @ApiModelProperty("Manager")
    private String Manager;

    /**
     * 主管项目领导
     */
     @ApiModelProperty("Supervisor")
    private String Supervisor;

    /**
     * 生产技术部
     */
     @ApiModelProperty("TechDepart")
    private String TechDepart;

    /**
     * 制表人
     */
     @ApiModelProperty("Tabulator")
    private String Tabulator;

    /**
     * 钻机编号
     */
     @ApiModelProperty("EquipmentID")
    private String EquipmentID;

    /**
     * 司机
     */
     @ApiModelProperty("Driver")
    private String Driver;

    /**
     * 钻机开始读数（H）
     */
     @ApiModelProperty("StartTime")
    private Float StartTime;

    /**
     * 钻机结束读数（H）
     */
     @ApiModelProperty("EndTime")
    private Float EndTime;

    /**
     * 钻机工作时间（H）
     */
     @ApiModelProperty("WorkTime")
    private Float WorkTime;

    /**
     * 孔深（m）
     */
     @ApiModelProperty("Depth")
    private Double Depth;

    /**
     * 排距（m）
     */
     @ApiModelProperty("RowSpace")
    private Double RowSpace;

    /**
     * 孔距（m）
     */
     @ApiModelProperty("HoleSpace")
    private Double HoleSpace;

    /**
     * 方位角
     */
     @ApiModelProperty("Azimuth")
    private Double Azimuth;

    /**
     * 倾角
     */
     @ApiModelProperty("Inclination")
    private Double Inclination;

    /**
     * 孔径(m)
     */
     @ApiModelProperty("Aperture")
    private Double Aperture;

    /**
     * 开孔坐标X
     */
     @ApiModelProperty("X")
    private Double x;

    /**
     * 开孔坐标Y
     */
     @ApiModelProperty("Y")
    private Double y;

    /**
     * 开孔坐标Z
     */
     @ApiModelProperty("Z")
    private Double z;

    /**
     * 单孔爆破量(m3)
     */
     @ApiModelProperty("HoleBlastVolume")
    private Double HoleBlastVolume;

    /**
     * 爆破日期
     */
     @ApiModelProperty("BlastDate")
    private LocalDateTime BlastDate;

    /**
     * 穿孔作业人
     */
     @ApiModelProperty("Operator")
    private String Operator;

    /**
     * 测量验收人
     */
     @ApiModelProperty("Accepter")
    private String Accepter;

    /**
     * 备注
     */
     @ApiModelProperty("Bz")
    private String Bz;

    /**
     * 日期标记,如:2021年01月
     */
     @ApiModelProperty("Tag")
    private String Tag;


     //以下是增加字段 需要表连接的字段  炮孔设计
    /**
     * 采区名称
     */
    @ApiModelProperty("StopeName")
    private String StopeName;

    /**
     * 平台名称
     */
    @ApiModelProperty("StepName")
    private String StepName;

    /**
     * 爆区名称
     */
    @ApiModelProperty("BlastAreaName")
    private String BlastAreaName;

    /**
     * 炮孔编号
     */
    @ApiModelProperty("HoleID")
    private String HoleID;

    /**
     * 穿孔日期
     */
    @ApiModelProperty("DrillingDate")
    private LocalDateTime DrillingDate;

    @ApiModelProperty("孔深（m）")
    private Double DesignDepth;

    @ApiModelProperty("排距（m）")
    private Double DesignRowSpace;

    @ApiModelProperty("孔距（m）")
    private Double DesignHoleSpace;

    @ApiModelProperty("设计方位角")
    private Double DesignAzimuth;

    @ApiModelProperty("设计倾角")
    private Double DesignInclination;

    @ApiModelProperty("设计孔径")
    private Double DesignAperture;

    @ApiModelProperty("台阶高度")
    private Double StepHeight;

    //以下是增加字段 爆破设计量表
    @ApiModelProperty("爆破设计量")
    private Double BlastVolume;

    @ApiModelProperty("设计时间")
    private LocalDateTime DesignDate;

}
