package cn.wise.sc.acquisition.business.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.StrUtil;
import cn.wise.im.common.http.R;
import cn.wise.sc.acquisition.business.mapper.DataStatisticsMapper;
import cn.wise.sc.acquisition.business.model.vo.DataStatisticsTableVo;
import cn.wise.sc.acquisition.business.model.vo.DataStatisticsVo;
import cn.wise.sc.acquisition.business.service.IDataStatisticsService;
import io.jsonwebtoken.lang.Assert;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.*;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author ztw
 * @since 2021-01-12
 */
@Service
public class DataStatisticsServiceImpl implements IDataStatisticsService {

	@Resource
	private DataStatisticsMapper dataStatisticsMapper;

	/**
	 * 产品产量统计-图
	 * @param TruckID
	 * @param cycle
	 * @param startDate
	 * @param endDate
	 * @return
	 */
	@Override
    public R<List<DataStatisticsVo>> countByPhoto(String TruckID, Integer cycle, String startDate, String endDate){
		Map<String, Object> params = new HashMap<>();
	    params.put("TruckID", TruckID);
        params.put("cycle", cycle);
        params.put("startDate", startDate);
        params.put("endDate", endDate);
        List<DataStatisticsVo> list = dataStatisticsMapper.countByPhoto(params);
        return R.ok(list);
    }

	/**
	 * 产品产量统计-表
	 * @param TruckID
	 * @param cycle
	 * @param startDate
	 * @param endDate
	 * @return
	 */
	@Override
	public R<List<DataStatisticsTableVo>> countByTable(String TruckID, Integer cycle, String startDate, String endDate){
		Map<String, Object> params = new HashMap<>();
		params.put("TruckID", TruckID);
		params.put("cycle", cycle);
		params.put("startDate", startDate);
		params.put("endDate", endDate);
		List<DataStatisticsTableVo> list = dataStatisticsMapper.countByTable(params);
		return R.ok(list);
	}




}
