package cn.wise.sc.acquisition.business.service.impl;

import cn.wise.im.common.http.R;
import cn.wise.sc.acquisition.business.constant.Rcode;
import cn.wise.sc.acquisition.business.entity.TSysUser;
import cn.wise.sc.acquisition.business.service.ITSysUserService;
import cn.wise.sc.acquisition.business.util.JwtUtil;
import cn.wise.sc.acquisition.business.util.MD5Util;
import cn.wise.sc.acquisition.business.util.RedisUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LoginService {

    @Autowired
    private ITSysUserService userService;

    @Autowired
    RedisUtil redisUtil;

    /**
     * 登录
     * @param LoginID
     * @param Password
     * @return
     */
    public R login(String LoginID, String Password) {
        Rcode.NOT_PARAM.assertNotNull(LoginID);
        Rcode.NOT_PARAM.assertNotNull(Password);
        QueryWrapper<TSysUser> wrapper = new QueryWrapper<>();
        wrapper.eq("LoginID", LoginID);
        TSysUser sysUser = userService.getOne(wrapper);
        Rcode.NOT_FOUND.assertNotNull(sysUser);
        if (!sysUser.getPassword().equals(Password)) {
            return R.fail(401,"密码错误");
        }
        //生成token,存入redis
        String token = JwtUtil.createToken(sysUser.getId(),
                sysUser.getName(),sysUser.getLoginID());
        System.out.println(token);
        redisUtil.setString(sysUser.getId().toString(), token, 3600);
        return R.ok(token);

    }

    //测试密码-MD5
    private static void main(String args[]){
        String loginPassWd = MD5Util.MD5Encode("123456","UTF-8");
        System.out.println(loginPassWd);
    }

}
